/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.tree.statement.InlineHTMLTree;
import org.sonar.plugins.php.api.tree.statement.UnsetVariableStatementTree;
import org.sonar.plugins.php.api.tree.statement.YieldStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2036")
public class FileWithSymbolsAndSideEffectsCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2036";
    private static final String MESSAGE = "Refactor this file to either declare symbols or cause side effects, but not both.";
    private boolean fileHasSymbol;
    private boolean fileHasSideEffect;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.fileHasSymbol = false;
        this.fileHasSideEffect = false;
        super.visitCompilationUnit(tree);
        if (this.fileHasSymbol && this.fileHasSideEffect) {
            this.context().newFileIssue(this, MESSAGE);
        }
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        if (tree.is(Tree.Kind.CLASS_DECLARATION, Tree.Kind.INTERFACE_DECLARATION)) {
            this.fileHasSymbol = true;
        }
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.fileHasSymbol = true;
    }

    @Override
    public void visitYieldStatement(YieldStatementTree tree) {
        super.visitYieldStatement(tree);
        this.fileHasSideEffect = true;
    }

    @Override
    public void visitInlineHTML(InlineHTMLTree tree) {
        if (!CheckUtils.isClosingTag(tree.inlineHTMLToken())) {
            this.fileHasSideEffect = true;
        }
    }

    @Override
    public void visitUnsetVariableStatement(UnsetVariableStatementTree tree) {
        super.visitUnsetVariableStatement(tree);
        this.fileHasSideEffect = true;
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        FunctionCallTree functionCallTree;
        String callee;
        super.visitExpressionStatement(tree);
        if (tree.expression().is(Tree.Kind.FUNCTION_CALL) && "define".equalsIgnoreCase(callee = (functionCallTree = (FunctionCallTree)tree.expression()).callee().toString())) {
            return;
        }
        this.fileHasSideEffect = true;
    }
}

