/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S126")
public class ElseIfWithoutElseCheck
extends PHPVisitorCheck {
    public static final String KEY = "S126";
    private static final String MESSAGE = "Add the missing \"else\" clause.";

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        List<ElseifClauseTree> elseifClauses = tree.elseifClauses();
        if (!elseifClauses.isEmpty() && tree.elseClause() == null) {
            ElseifClauseTree lastElseIf = elseifClauses.get(elseifClauses.size() - 1);
            this.context().newIssue(this, lastElseIf.elseifToken(), MESSAGE);
        }
    }

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        IfStatementTree nestedIf;
        super.visitElseClause(tree);
        if (tree.is(Tree.Kind.ELSE_CLAUSE) && tree.statements().get(0).is(Tree.Kind.IF_STATEMENT) && (nestedIf = (IfStatementTree)tree.statements().get(0)).elseClause() == null && nestedIf.elseifClauses().isEmpty()) {
            this.context().newIssue(this, tree.elseToken(), nestedIf.ifToken(), MESSAGE);
        }
    }
}

