/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.TreeSet;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1536")
public class DuplicatedFunctionArgumentCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1536";
    private static final String MESSAGE = "Rename the duplicated function %s \"%s\".";

    @Override
    public void visitParameterList(ParameterListTree parameterList) {
        HashSet<String> parameterNames = Sets.newHashSet();
        TreeSet<String> duplicatedParamNames = Sets.newTreeSet();
        for (ParameterTree parameter : parameterList.parameters()) {
            String name = parameter.variableIdentifier().variableExpression().text();
            boolean isNewName = parameterNames.add(name);
            if (isNewName) continue;
            duplicatedParamNames.add(name);
        }
        if (!duplicatedParamNames.isEmpty()) {
            String listString = Joiner.on(", ").join(duplicatedParamNames);
            this.context().newIssue(this, parameterList, String.format(MESSAGE, duplicatedParamNames.size() == 1 ? "parameter" : "parameters", listString));
        }
        super.visitParameterList(parameterList);
    }
}

