/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractDuplicateBranchCheck;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;

@Rule(key="S1862")
public class DuplicateConditionCheck
extends AbstractDuplicateBranchCheck {
    public static final String KEY = "S1862";
    private static final String MESSAGE = "This %s duplicates the one on line %s.";

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        super.visitSwitchStatement(tree);
        ArrayList<ExpressionTree> expressions = new ArrayList<ExpressionTree>();
        for (SwitchCaseClauseTree switchCaseClauseTree : tree.cases()) {
            if (!switchCaseClauseTree.is(Tree.Kind.CASE_CLAUSE)) continue;
            expressions.add(((CaseClauseTree)switchCaseClauseTree).expression());
        }
        this.checkForEquality(expressions, "case");
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (tree.is(Tree.Kind.IF_STATEMENT) && !this.checkedIfStatements.contains(tree)) {
            ArrayList<ExpressionTree> conditionsList = new ArrayList<ExpressionTree>();
            for (Tree clause : this.getClauses(tree)) {
                if (clause.is(Tree.Kind.IF_STATEMENT)) {
                    conditionsList.add(((IfStatementTree)clause).condition());
                    continue;
                }
                if (!clause.is(Tree.Kind.ELSEIF_CLAUSE)) continue;
                conditionsList.add(((ElseifClauseTree)clause).condition());
            }
            this.checkForEquality(conditionsList, "branch");
        }
        super.visitIfStatement(tree);
    }

    private void checkForEquality(List<ExpressionTree> list, String branchType) {
        block0: for (int i = 1; i < list.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!SyntacticEquivalence.areSyntacticallyEquivalent(list.get(i), list.get(j))) continue;
                this.raiseIssue(branchType, list.get(j), list.get(i));
                continue block0;
            }
        }
    }

    private void raiseIssue(String branchType, Tree duplicatedTree, Tree duplicatingTree) {
        String message = String.format(MESSAGE, branchType, ((PHPTree)duplicatedTree).getLine());
        this.context().newIssue(this, duplicatingTree, message).secondary(duplicatedTree, null);
    }
}

