/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractDuplicateBranchImplementationCheck;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.StatementTree;

@Rule(key="S1871")
public class DuplicateBranchImplementationCheck
extends AbstractDuplicateBranchImplementationCheck {
    public static final String KEY = "S1871";
    private static final String MESSAGE = "This %s's code block is the same as the block for the %s on line %s.";

    @Override
    protected void onAllEquivalentBranches(SyntaxToken keyword) {
    }

    @Override
    protected void checkForDuplication(String branchType, List<List<StatementTree>> list) {
        block0: for (int i = 1; i < list.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!DuplicateBranchImplementationCheck.areSyntacticallyEquivalent(list.get(i), list.get(j))) continue;
                this.raiseIssue(branchType, list.get(j), list.get(i));
                continue block0;
            }
        }
    }

    private static boolean areSyntacticallyEquivalent(List<StatementTree> list1, List<StatementTree> list2) {
        boolean bothEmpty = list1.isEmpty() && list2.isEmpty();
        return !bothEmpty && SyntacticEquivalence.areSyntacticallyEquivalent(list1.iterator(), list2.iterator());
    }

    private void raiseIssue(String branchType, List<StatementTree> duplicatedTree, List<StatementTree> duplicatingTree) {
        String message = String.format(MESSAGE, branchType, branchType, ((PHPTree)((Object)duplicatedTree.get(0))).getLine());
        this.context().newIssue(this, duplicatingTree.get(0), duplicatingTree.get(duplicatingTree.size() - 1), message).secondary(duplicatedTree.get(0), duplicatedTree.get(duplicatedTree.size() - 1), null);
    }
}

