/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractStatementsCheck;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;

@Rule(key="S1763")
public class CodeFollowingJumpStatementCheck
extends AbstractStatementsCheck {
    public static final String KEY = "S1763";
    private static final String MESSAGE = "Remove the code after this \"%s\".";
    private static final Tree.Kind[] JUMP_KINDS = new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.THROW_STATEMENT};
    private static final Tree.Kind[] NO_ACTION_KINDS = new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT, Tree.Kind.CLASS_DECLARATION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.INTERFACE_DECLARATION, Tree.Kind.TRAIT_DECLARATION, Tree.Kind.NAMESPACE_STATEMENT, Tree.Kind.USE_STATEMENT, Tree.Kind.CONSTANT_DECLARATION, Tree.Kind.INLINE_HTML};

    @Override
    public void visitNode(Tree tree) {
        List<StatementTree> statements = CodeFollowingJumpStatementCheck.getStatements(tree);
        for (int i = 0; i < statements.size() - 1; ++i) {
            StatementTree currentStatement = statements.get(i);
            if (!currentStatement.is(JUMP_KINDS) || !CodeFollowingJumpStatementCheck.hasActionStatementAfter(statements, i)) continue;
            String message = String.format(MESSAGE, ((PHPTree)((Object)currentStatement)).getFirstToken().text());
            this.context().newIssue(this, ((PHPTree)((Object)currentStatement)).getFirstToken(), message);
        }
    }

    private static boolean hasActionStatementAfter(List<StatementTree> statements, int currentStatementNumber) {
        for (int i = currentStatementNumber + 1; i < statements.size(); ++i) {
            if (statements.get(i).is(NO_ACTION_KINDS)) continue;
            return true;
        }
        return false;
    }
}

