/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S101")
public class ClassNameCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S101";
    private static final String MESSAGE = "Rename class \"%s\" to match the regular expression %s.";
    public static final String DEFAULT = "^[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    String format = "^[A-Z][a-zA-Z0-9]*$";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of(Tree.Kind.CLASS_DECLARATION);
    }

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    @Override
    public void visitNode(Tree tree) {
        NameIdentifierTree nameTree = ((ClassDeclarationTree)tree).name();
        String className = nameTree.text();
        if (!this.pattern.matcher(className).matches()) {
            String message = String.format(MESSAGE, className, this.format);
            this.context().newIssue(this, nameTree, message);
        }
    }
}

