/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2000")
public class CharacterBeforeOpeningPHPTagCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2000";
    private static final String MESSAGE = "Remove the extra characters before the open tag.";
    private static final Pattern OPENING_TAG = Pattern.compile("(?i)(?:<\\?(?:php|=|)|<%)");

    @Override
    public void visitScript(ScriptTree tree) {
        SyntaxToken openingTagToken = tree.fileOpeningTagToken();
        if (openingTagToken.column() != 0 || openingTagToken.line() != 1 || !OPENING_TAG.matcher(openingTagToken.text()).matches()) {
            this.context().newIssue(this, openingTagToken, MESSAGE);
        }
    }
}

