/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2050")
public class AliasFunctionUsageCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2050";
    public static final String MESSAGE = "Replace this use of \"%s\" with \"%s\".";
    private static final Map<String, String> ALIAS_FUNCTIONS = ImmutableMap.builder().put("chop", "rtrim").put("close", "closedir").put("doubleval", "floatval").put("fputs", "fwrite").put("ini_alter", "ini_set").put("is_double", "is_float").put("is_integer", "is_int").put("is_long", "is_int").put("is_real", "is_float").put("is_writeable", "is_writable").put("join", "implode").put("key_exists", "array_key_exists").put("magic_quotes_runtime", "set_magic_quotes_runtime").put("pos", "current").put("show_source", "highlight_file").put("sizeof", "count").put("strchr", "strstr").build();

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String name;
        String replacementName;
        ExpressionTree callee = tree.callee();
        if (callee.is(Tree.Kind.NAMESPACE_NAME) && (replacementName = ALIAS_FUNCTIONS.get((name = ((NamespaceNameTree)callee).fullName()).toLowerCase(Locale.ROOT))) != null) {
            this.context().newIssue(this, callee, String.format(MESSAGE, name, replacementName));
        }
        super.visitFunctionCall(tree);
    }
}

