/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.typed.ActionParser;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.php.highlighter.SymbolHighlighter;
import org.sonar.php.highlighter.SyntaxHighlighterVisitor;
import org.sonar.php.metrics.CommentLineVisitor;
import org.sonar.php.metrics.CpdVisitor;
import org.sonar.php.metrics.FileMeasures;
import org.sonar.php.metrics.MetricsVisitor;
import org.sonar.php.parser.PHPParserBuilder;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PhpFile;
import org.sonar.plugins.php.api.visitors.PhpIssue;

public class PHPAnalyzer {
    private final ActionParser<Tree> parser = PHPParserBuilder.createParser();
    private final ImmutableList<PHPCheck> checks;
    private CompilationUnitTree currentFileTree;
    private PhpFile currentFile;
    private SymbolTable currentFileSymbolTable;

    public PHPAnalyzer(ImmutableList<PHPCheck> checks) {
        this.checks = checks;
        for (PHPCheck check : checks) {
            check.init();
        }
    }

    public void nextFile(PhpFile file) {
        this.currentFile = file;
        this.currentFileTree = (CompilationUnitTree)this.parser.parse(file.contents());
        this.currentFileSymbolTable = SymbolTableImpl.create(this.currentFileTree);
    }

    public List<PhpIssue> analyze() {
        ImmutableList.Builder issuesBuilder = ImmutableList.builder();
        for (PHPCheck check : this.checks) {
            issuesBuilder.addAll(check.analyze(this.currentFile, this.currentFileTree, this.currentFileSymbolTable));
        }
        return issuesBuilder.build();
    }

    public FileMeasures computeMeasures(FileLinesContext fileLinesContext) {
        return new MetricsVisitor().getFileMeasures(this.currentFile, this.currentFileTree, fileLinesContext);
    }

    public NewHighlighting getSyntaxHighlighting(SensorContext context, InputFile inputFile) {
        NewHighlighting highlighting = context.newHighlighting().onFile(inputFile);
        SyntaxHighlighterVisitor.highlight(this.currentFileTree, highlighting);
        return highlighting;
    }

    public NewSymbolTable getSymbolHighlighting(SensorContext context, InputFile inputFile) {
        NewSymbolTable symbolTable = context.newSymbolTable().onFile(inputFile);
        new SymbolHighlighter().highlight(this.currentFileSymbolTable, symbolTable);
        return symbolTable;
    }

    public List<CpdVisitor.CpdToken> computeCpdTokens() {
        return new CpdVisitor().getCpdTokens(this.currentFile, this.currentFileTree);
    }

    public Set<Integer> computeNoSonarLines() {
        return new CommentLineVisitor(this.currentFileTree).noSonarLines();
    }
}

