/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.testing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.RspecKey;
import org.sonar.java.testing.CheckVerifier;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

class Expectations {
    private static final Map<String, IssueAttribute> ATTRIBUTE_MAP = ImmutableMap.builder().put((Object)"message", (Object)IssueAttribute.MESSAGE).put((Object)"effortToFix", (Object)IssueAttribute.EFFORT_TO_FIX).put((Object)"sc", (Object)IssueAttribute.START_COLUMN).put((Object)"startColumn", (Object)IssueAttribute.START_COLUMN).put((Object)"el", (Object)IssueAttribute.END_LINE).put((Object)"endLine", (Object)IssueAttribute.END_LINE).put((Object)"ec", (Object)IssueAttribute.END_COLUMN).put((Object)"endColumn", (Object)IssueAttribute.END_COLUMN).put((Object)"secondary", (Object)IssueAttribute.SECONDARY_LOCATIONS).put((Object)"flows", (Object)IssueAttribute.FLOWS).put((Object)"order", (Object)IssueAttribute.ORDER).build();
    final Multimap<Integer, Issue> issues = ArrayListMultimap.create();
    final SortedSetMultimap<String, FlowComment> flows = TreeMultimap.create(String::compareTo, Collections.reverseOrder((rec$, x$0) -> FlowComment.access$800((FlowComment)rec$, x$0)));
    private boolean expectNoIssues = false;
    private String expectedProjectIssue = null;
    private String expectedFileIssue = null;
    private Set<String> seenFlowIds = new HashSet<String>();

    Expectations() {
    }

    void setExpectNoIssues() {
        this.expectNoIssues = true;
    }

    boolean expectNoIssues() {
        return this.expectNoIssues;
    }

    boolean expectIssueAtFileLevel() {
        return StringUtils.isNotEmpty((String)this.expectedFileIssue);
    }

    void setExpectedFileIssue(String expectedMessage) {
        this.expectedFileIssue = expectedMessage;
    }

    String expectedFileIssue() {
        return this.expectedFileIssue;
    }

    boolean expectIssueAtProjectLevel() {
        return StringUtils.isNotEmpty((String)this.expectedProjectIssue);
    }

    void setExpectedProjectIssue(String expectedMessage) {
        this.expectedProjectIssue = expectedMessage;
    }

    String expectedProjectIssue() {
        return this.expectedProjectIssue;
    }

    Optional<String> containFlow(List<AnalyzerMessage> actual) {
        List<Integer> actualLines = Expectations.flowToLines(actual, AnalyzerMessage::getLine);
        Set expectedFlows = this.flows.keySet().stream().filter(flowId -> !this.seenFlowIds.contains(flowId)).filter(flowId -> Expectations.flowToLines(this.flows.get(flowId), f -> f.line).equals(actualLines)).collect(Collectors.toSet());
        if (expectedFlows.isEmpty()) {
            return Optional.empty();
        }
        if (expectedFlows.size() == 1) {
            String flowId2 = (String)Iterables.getOnlyElement(expectedFlows);
            this.seenFlowIds.add(flowId2);
            return Optional.of(flowId2);
        }
        List actualMessages = actual.stream().map(AnalyzerMessage::getMessage).collect(Collectors.toList());
        Optional<String> foundFlow = expectedFlows.stream().filter(flowId -> this.hasSameMessages((String)flowId, actualMessages)).findFirst();
        foundFlow.ifPresent(flowId -> this.seenFlowIds.add((String)flowId));
        return foundFlow;
    }

    private boolean hasSameMessages(String flowId, List<String> actualMessages) {
        List expectedMessages = this.flows.get((Object)flowId).stream().map(FlowComment::message).collect(Collectors.toList());
        return expectedMessages.equals(actualMessages);
    }

    Set<String> unseenFlowIds() {
        return Sets.difference((Set)this.flows.keySet(), this.seenFlowIds);
    }

    private static <T> List<Integer> flowToLines(Collection<T> flow, ToIntFunction<T> toLineFunction) {
        return flow.stream().mapToInt(toLineFunction).boxed().collect(Collectors.toList());
    }

    String flowToLines(String flowId) {
        return this.flows.get((Object)flowId).stream().map(f -> String.valueOf(f.line)).collect(Collectors.joining(","));
    }

    Parser parser() {
        return new Parser((Multimap)this.issues, (Multimap)this.flows);
    }

    Parser noEffectParser() {
        Parser parser = new Parser((Multimap)this.issues, (Multimap)this.flows);
        parser.nonCompliantComment = Pattern.compile("NO_ISSUES_WILL_BE_COLLECTED");
        parser.shift = Pattern.compile("NO_ISSUES_WILL_BE_COLLECTED");
        return parser;
    }

    @CheckForNull
    static RemediationFunction remediationFunction(AnalyzerMessage issue) {
        String ruleKey = Expectations.ruleKey(issue);
        try {
            RuleJSON rule = Expectations.getRuleJSON(ruleKey);
            if (rule.remediation == null) {
                return null;
            }
            switch (rule.remediation.func) {
                case "Linear": {
                    return RemediationFunction.LINEAR;
                }
                case "Constant/Issue": {
                    return RemediationFunction.CONST;
                }
            }
            return null;
        }
        catch (JsonParseException | IOException e) {
            return null;
        }
    }

    private static RuleJSON getRuleJSON(String ruleKey) throws IOException {
        String ruleJson = "/org/sonar/l10n/java/rules/java/" + ruleKey + "_java.json";
        URL resource = CheckVerifier.class.getResource(ruleJson);
        if (resource == null) {
            throw new IOException(ruleJson + " not found");
        }
        Gson gson = new Gson();
        return (RuleJSON)gson.fromJson((Reader)new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8), RuleJSON.class);
    }

    private static String ruleKey(AnalyzerMessage issue) {
        String ruleKey;
        RspecKey rspecKeyAnnotation = (RspecKey)AnnotationUtils.getAnnotation(issue.getCheck().getClass(), RspecKey.class);
        if (rspecKeyAnnotation != null) {
            ruleKey = rspecKeyAnnotation.value();
        } else {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(issue.getCheck().getClass(), Rule.class);
            if (ruleAnnotation != null) {
                ruleKey = ruleAnnotation.key();
            } else {
                throw new AssertionError((Object)"Rules should be annotated with '@Rule(key = \"...\")' annotation (org.sonar.check.Rule).");
            }
        }
        return ruleKey;
    }

    static class RuleJSON {
        Remediation remediation;

        RuleJSON() {
        }

        static class Remediation {
            String func;

            Remediation() {
            }
        }
    }

    static enum RemediationFunction {
        LINEAR,
        CONST;

    }

    @VisibleForTesting
    static class Parser
    extends IssuableSubscriptionVisitor {
        private static final String NONCOMPLIANT_FLAG = "Noncompliant";
        private Pattern nonCompliantComment = Pattern.compile("//\\s+Noncompliant");
        private Pattern shift = Pattern.compile("Noncompliant@(\\S+)");
        private static final Pattern FLOW_COMMENT = Pattern.compile("//\\s+flow");
        private static final Pattern FLOW = Pattern.compile("flow@(?<ids>\\S+).*?(?=flow@)?");
        private final Multimap<String, FlowComment> flows;
        private final Multimap<Integer, Issue> issues;

        private Parser(Multimap<Integer, Issue> issues, Multimap<String, FlowComment> flows) {
            this.issues = issues;
            this.flows = flows;
        }

        @Override
        public List<Tree.Kind> nodesToVisit() {
            return Collections.singletonList(Tree.Kind.TRIVIA);
        }

        @Override
        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            this.collectExpectedIssues(syntaxTrivia.comment(), syntaxTrivia.startLine());
        }

        @VisibleForTesting
        void collectExpectedIssues(String comment, int line) {
            if (this.nonCompliantComment.matcher(comment).find()) {
                ParsedComment parsedComment = this.parseIssue(comment, line);
                this.issues.put((Object)((Integer)IssueAttribute.LINE.get(parsedComment.issue)), (Object)parsedComment.issue);
                parsedComment.flows.forEach(f -> this.flows.put((Object)f.id, f));
            }
            if (FLOW_COMMENT.matcher(comment).find()) {
                Parser.parseFlows(comment, line).forEach(f -> this.flows.put((Object)f.id, f));
            }
        }

        @VisibleForTesting
        static List<FlowComment> parseFlows(@Nullable String comment, int line) {
            if (comment == null) {
                return Collections.emptyList();
            }
            ArrayList<List<String>> flowIds = new ArrayList<List<String>>();
            ArrayList<Integer> flowStarts = new ArrayList<Integer>();
            Matcher matcher = FLOW.matcher(comment);
            while (matcher.find()) {
                List<String> ids = Arrays.asList(matcher.group("ids").split(","));
                flowIds.add(ids);
                flowStarts.add(matcher.start());
            }
            flowStarts.add(comment.length());
            return IntStream.range(0, flowIds.size()).mapToObj(i -> Parser.createFlows((List)flowIds.get(i), line, (Integer)flowStarts.get(i), comment.substring((Integer)flowStarts.get(i), (Integer)flowStarts.get(i + 1)))).flatMap(Function.identity()).collect(Collectors.toList());
        }

        private static Stream<FlowComment> createFlows(List<String> ids, int line, int startColumn, String flow) {
            EnumMap<IssueAttribute, Object> attributes = new EnumMap<IssueAttribute, Object>(IssueAttribute.class);
            attributes.putAll(Parser.parseAttributes(flow));
            String message = Parser.parseMessage(flow, flow.length());
            attributes.put(IssueAttribute.MESSAGE, message);
            return ids.stream().map(id -> new FlowComment((String)id, line, startColumn, attributes));
        }

        @VisibleForTesting
        ParsedComment parseIssue(String comment, int line) {
            Matcher shiftMatcher = this.shift.matcher(comment);
            Matcher flowMatcher = FLOW.matcher(comment);
            return Parser.createIssue(line, shiftMatcher.find() ? shiftMatcher.group(1) : null, comment, Parser.parseMessage(comment, flowMatcher.find() ? flowMatcher.start() : comment.length()), comment);
        }

        private static ParsedComment createIssue(int line, @Nullable String shift, @Nullable String attributes, @Nullable String message, @Nullable String flow) {
            Issue issue = new Issue();
            issue.put(IssueAttribute.LINE, Parser.parseLineShifting(shift).getLine(line));
            Map<IssueAttribute, Object> attrs = Parser.parseAttributes(attributes);
            attrs = Parser.adjustEndLine(attrs, line);
            issue.putAll(attrs);
            if (message != null) {
                issue.put(IssueAttribute.MESSAGE, message);
            }
            List<FlowComment> flows = Parser.parseFlows(flow, line);
            return new ParsedComment(issue, flows);
        }

        private static LineRef parseLineShifting(@Nullable String shift) {
            if (shift == null) {
                return new LineRef.RelativeLineRef(0);
            }
            try {
                return LineRef.fromString(shift);
            }
            catch (NumberFormatException e) {
                throw new AssertionError((Object)"Use only '@+N' or '@-N' to shifts messages.");
            }
        }

        private static Map<IssueAttribute, Object> parseAttributes(@Nullable String comment) {
            if ((comment = StringUtils.substringBetween((String)comment, (String)"[[", (String)"]]")) == null) {
                return Collections.emptyMap();
            }
            return Arrays.stream(comment.split(";")).map(Parser::parseAttribute).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private static Map<IssueAttribute, Object> adjustEndLine(Map<IssueAttribute, Object> attributes, int line) {
            Object endLine = attributes.get((Object)IssueAttribute.END_LINE);
            if (endLine instanceof LineRef.RelativeLineRef) {
                LineRef.RelativeLineRef relativeLineRef = (LineRef.RelativeLineRef)endLine;
                if (relativeLineRef.offset < 0) {
                    throw new AssertionError((Object)"endLine attribute should be relative to the line and must be +N with N integer");
                }
                EnumMap<IssueAttribute, Object> copy = new EnumMap<IssueAttribute, Object>(attributes);
                copy.put(IssueAttribute.END_LINE, (Object)new LineRef.AbsoluteLineRef(relativeLineRef.getLine(line)));
                return copy;
            }
            return attributes;
        }

        private static Map.Entry<IssueAttribute, Object> parseAttribute(String attribute) {
            try (Scanner scanner = new Scanner(attribute);){
                scanner.useDelimiter("[=]+");
                String name = scanner.next();
                if (!ATTRIBUTE_MAP.containsKey(name)) {
                    throw new AssertionError((Object)String.format("// Noncompliant attributes not valid: '%s'", attribute));
                }
                IssueAttribute key = (IssueAttribute)((Object)ATTRIBUTE_MAP.get(name));
                Object value = key.setter.apply(scanner.hasNext() ? scanner.next() : null);
                AbstractMap.SimpleImmutableEntry<IssueAttribute, Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<IssueAttribute, Object>(key, value);
                return simpleImmutableEntry;
            }
        }

        private static String parseMessage(String cleanedComment, int horizon) {
            return StringUtils.substringBetween((String)cleanedComment.substring(0, horizon), (String)"{{", (String)"}}");
        }

        static abstract class LineRef {
            LineRef() {
            }

            abstract int getLine(int var1);

            static LineRef fromString(String input) {
                if (input.startsWith("+") || input.startsWith("-")) {
                    return new RelativeLineRef(Integer.valueOf(input));
                }
                return new AbsoluteLineRef(Integer.valueOf(input));
            }

            static int toLine(Object ref) {
                return ((LineRef)ref).getLine(0);
            }

            public int hashCode() {
                return Objects.hash(this.getLine(0));
            }

            public boolean equals(Object obj) {
                return obj != null && LineRef.class.isAssignableFrom(obj.getClass()) && Objects.equals(this.getLine(0), ((LineRef)obj).getLine(0));
            }

            static class RelativeLineRef
            extends LineRef {
                final int offset;

                RelativeLineRef(int offset) {
                    this.offset = offset;
                }

                @Override
                int getLine(int ref) {
                    return ref + this.offset;
                }
            }

            static class AbsoluteLineRef
            extends LineRef {
                final int line;

                public AbsoluteLineRef(int line) {
                    this.line = line;
                }

                @Override
                public int getLine(int ref) {
                    return this.line;
                }
            }
        }

        static class ParsedComment {
            final Issue issue;
            final List<FlowComment> flows;

            private ParsedComment(Issue issue, List<FlowComment> flows) {
                this.issue = issue;
                this.flows = flows;
            }
        }
    }

    static class FlowComment {
        final String id;
        final int line;
        final Map<IssueAttribute, Object> attributes;
        final int startColumn;

        private FlowComment(String id, int line, int startColumn, Map<IssueAttribute, Object> attributes) {
            this.id = id;
            this.line = line;
            this.startColumn = startColumn;
            this.attributes = Collections.unmodifiableMap(attributes);
        }

        private int compareTo(FlowComment other) {
            if (this == other) {
                return 0;
            }
            Integer thisOrder = (Integer)IssueAttribute.ORDER.get(this.attributes);
            Integer otherOrder = (Integer)IssueAttribute.ORDER.get(other.attributes);
            if (thisOrder != null && otherOrder != null) {
                if (thisOrder.equals(otherOrder)) {
                    throw new AssertionError((Object)String.format("Same explicit ORDER=%s provided for two comments.%n%s%n%s", thisOrder, this, other));
                }
                return thisOrder.compareTo(otherOrder);
            }
            if (thisOrder == null && otherOrder == null) {
                int compareLines = Integer.compare(this.line, other.line);
                return compareLines != 0 ? compareLines : Integer.compare(this.startColumn, other.startColumn);
            }
            throw new AssertionError((Object)String.format("Mixed explicit and implicit order in same flow.%n%s%n%s", this, other));
        }

        @CheckForNull
        String message() {
            return (String)IssueAttribute.MESSAGE.get(this.attributes);
        }

        public String toString() {
            return String.format("%d: flow@%s %s", this.line, this.id, this.attributes.toString());
        }
    }

    static class Issue
    extends EnumMap<IssueAttribute, Object> {
        private Issue() {
            super(IssueAttribute.class);
        }
    }

    static enum IssueAttribute {
        LINE(Function.identity()),
        ORDER(Integer::valueOf),
        MESSAGE(Function.identity()),
        START_COLUMN(Integer::valueOf),
        END_COLUMN(Integer::valueOf),
        END_LINE(Parser.LineRef::fromString, Parser.LineRef::toLine),
        EFFORT_TO_FIX(Double::valueOf),
        SECONDARY_LOCATIONS(IssueAttribute.multiValueAttribute(Integer::valueOf)),
        FLOWS(IssueAttribute.multiValueAttribute(Function.identity()));

        private Function<String, ?> setter;
        private Function<Object, Object> getter = Function.identity();

        private IssueAttribute(Function<String, ?> setter) {
            this.setter = setter;
        }

        private IssueAttribute(Function<String, ?> setter, UnaryOperator<Object> getter) {
            this.setter = setter;
            this.getter = getter;
        }

        private static <T> Function<String, List<T>> multiValueAttribute(Function<String, T> convert) {
            return input -> Strings.isNullOrEmpty((String)input) ? Collections.emptyList() : Arrays.stream(input.split(",")).map(String::trim).map(convert).collect(Collectors.toList());
        }

        <T> T get(Map<IssueAttribute, Object> values) {
            Object rawValue = values.get((Object)this);
            return (T)(rawValue == null ? null : this.getter.apply(rawValue));
        }
    }
}

