/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks.debug;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.DebugCheck;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.CheckerDispatcher;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;

@Rule(key="DEBUG-SE-Interrupted", name="DEBUG(SE): Interrupted exploration", description="Raise an issue on each methods which triggered SE, but did not completed.", priority=Priority.INFO, tags={"debug"})
public class DebugInterruptedExecutionCheck
extends SECheck
implements DebugCheck {
    private Deque<IdentifierTree> methodNames = new LinkedList<IdentifierTree>();

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.methodNames.push(methodTree.simpleName());
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        Exception cause = ((CheckerDispatcher)context).interruptionCause();
        Preconditions.checkNotNull((Object)cause, (Object)"cause should always be present when exploration is interrupted");
        this.reportIssue(this.methodNames.pop(), "SE Interrupted: " + cause.getMessage());
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        this.methodNames.pop();
    }
}

