/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3824")
public class MapComputeIfAbsentOrPresentCheck
extends SECheck
implements JavaVersionAwareVisitor {
    private static final MethodMatchers.NameBuilder JAVA_UTIL_MAP = MethodMatchers.create().ofSubTypes("java.util.Map");
    private static final MethodMatchers MAP_GET = JAVA_UTIL_MAP.names("get").addParametersMatcher("*").build();
    private static final MethodMatchers MAP_PUT = JAVA_UTIL_MAP.names("put").addParametersMatcher("*", "*").build();
    private final Multimap<SymbolicValue, MapGetInvocation> mapGetInvocations = LinkedListMultimap.create();
    private final List<CheckIssue> checkIssues = new ArrayList<CheckIssue>();

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.mapGetInvocations.clear();
        this.checkIssues.clear();
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        MethodInvocationTree mit;
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION) && MAP_GET.matches(mit = (MethodInvocationTree)syntaxNode)) {
            ProgramState psBeforeInvocation = context.getNode().programState;
            ProgramState psAfterInvocation = context.getState();
            SymbolicValue keySV = psBeforeInvocation.peekValue(0);
            SymbolicValue mapSV = psBeforeInvocation.peekValue(1);
            SymbolicValue valueSV = psAfterInvocation.peekValue();
            this.mapGetInvocations.put((Object)mapSV, (Object)new MapGetInvocation(valueSV, keySV, mit));
        }
        return super.checkPostStatement(context, syntaxNode);
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        MethodInvocationTree mit;
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION) && MAP_PUT.matches(mit = (MethodInvocationTree)syntaxNode) && !MapComputeIfAbsentOrPresentCheck.isMethodInvocationThrowingCheckedException((ExpressionTree)mit.arguments().get(1))) {
            ProgramState ps = context.getState();
            SymbolicValue keySV = ps.peekValue(1);
            SymbolicValue mapSV = ps.peekValue(2);
            this.mapGetInvocations.get((Object)mapSV).stream().filter(getOnSameMap -> ((MapGetInvocation)getOnSameMap).withSameKey(keySV)).findAny().ifPresent(getOnSameMap -> {
                ObjectConstraint constraint = ps.getConstraint(((MapGetInvocation)getOnSameMap).value, ObjectConstraint.class);
                if (constraint != null && MapComputeIfAbsentOrPresentCheck.isInsideIfStatementWithNullCheckWithoutElse(mit)) {
                    this.checkIssues.add(new CheckIssue(context.getNode(), ((MapGetInvocation)getOnSameMap).mit, mit, ((MapGetInvocation)getOnSameMap).value, constraint));
                }
            });
        }
        return super.checkPreStatement(context, syntaxNode);
    }

    private static boolean isMethodInvocationThrowingCheckedException(ExpressionTree expr) {
        if (!expr.is(Tree.Kind.METHOD_INVOCATION)) {
            return false;
        }
        Symbol symbol = ((MethodInvocationTree)expr).symbol();
        if (!symbol.isMethodSymbol()) {
            return true;
        }
        return ((Symbol.MethodSymbol)symbol).thrownTypes().stream().anyMatch(t -> !t.isSubtypeOf("java.lang.RuntimeException"));
    }

    private static boolean isInsideIfStatementWithNullCheckWithoutElse(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(Tree.Kind.IF_STATEMENT); parent = parent.parent()) {
        }
        if (parent == null) {
            return false;
        }
        IfStatementTree ifStatementTree = (IfStatementTree)parent;
        return ifStatementTree.elseStatement() == null && MapComputeIfAbsentOrPresentCheck.isNullCheck(ExpressionUtils.skipParentheses(ifStatementTree.condition()));
    }

    private static boolean isNullCheck(ExpressionTree condition) {
        if (condition.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO)) {
            BinaryExpressionTree bet = (BinaryExpressionTree)condition;
            ExpressionTree rightOperand = ExpressionUtils.skipParentheses(bet.rightOperand());
            ExpressionTree leftOperand = ExpressionUtils.skipParentheses(bet.leftOperand());
            return rightOperand.is(Tree.Kind.NULL_LITERAL) || leftOperand.is(Tree.Kind.NULL_LITERAL);
        }
        return false;
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        MapComputeIfAbsentOrPresentCheck check = this;
        this.checkIssues.stream().filter(checkIssue -> ((CheckIssue)checkIssue).isOnlyPossibleIssueForReportTree(this.checkIssues)).forEach(issue -> ((CheckIssue)issue).report(context, check));
    }

    private static class MapGetInvocation {
        private final SymbolicValue value;
        private final SymbolicValue key;
        private final MethodInvocationTree mit;

        private MapGetInvocation(SymbolicValue value, SymbolicValue key, MethodInvocationTree mit) {
            this.value = value;
            this.key = key;
            this.mit = mit;
        }

        private boolean withSameKey(SymbolicValue key) {
            return this.key.equals(key);
        }
    }

    private static class CheckIssue {
        private final ExplodedGraph.Node node;
        private final MethodInvocationTree getInvocation;
        private final MethodInvocationTree putInvocation;
        private final SymbolicValue value;
        private final ObjectConstraint valueConstraint;

        private CheckIssue(ExplodedGraph.Node node, MethodInvocationTree getInvocation, MethodInvocationTree putInvocation, SymbolicValue value, ObjectConstraint valueConstraint) {
            this.node = node;
            this.getInvocation = getInvocation;
            this.putInvocation = putInvocation;
            this.value = value;
            this.valueConstraint = valueConstraint;
        }

        private boolean isOnlyPossibleIssueForReportTree(List<CheckIssue> otherIssues) {
            return otherIssues.stream().noneMatch(this::differentIssueOnSameTree);
        }

        private boolean differentIssueOnSameTree(CheckIssue otherIssue) {
            return this != otherIssue && this.getInvocation.equals(otherIssue.getInvocation) && this.valueConstraint != otherIssue.valueConstraint;
        }

        private void report(CheckerContext context, SECheck check) {
            context.reportIssue(this.getInvocation, check, this.issueMsg(), this.flows());
        }

        private String issueMsg() {
            return String.format("Replace this \"Map.get()\" and condition with a call to \"Map.%s()\".", this.valueConstraint == ObjectConstraint.NULL ? "computeIfAbsent" : "computeIfPresent");
        }

        private Set<Flow> flows() {
            Set<Flow> flows = FlowComputation.flow(this.node, this.value, Collections.singletonList(ObjectConstraint.class));
            return flows.stream().map(flow -> Flow.builder().add(new JavaFileScannerContext.Location("'Map.put()' is invoked with same key.", this.putInvocation.methodSelect())).addAll((Flow)flow).add(new JavaFileScannerContext.Location("'Map.get()' is invoked.", this.getInvocation.methodSelect())).build()).collect(Collectors.toSet());
        }
    }
}

