/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sonar.java.cfg.CFG;
import org.sonar.plugins.java.api.tree.Tree;

public class ProgramPoint {
    private final int hashcode;
    public final CFG.IBlock<?> block;
    public final int i;

    public ProgramPoint(CFG.IBlock<?> block) {
        this(block, 0);
    }

    private ProgramPoint(CFG.IBlock<?> block, int i) {
        int blockSize = block.elements().size();
        Preconditions.checkState((i < blockSize + 2 ? 1 : 0) != 0, (String)"CFG Block has %s elements but PP at %s was requested", (int)blockSize, (int)i);
        this.block = block;
        this.i = i;
        this.hashcode = block.id() * 31 + i;
    }

    public ProgramPoint next() {
        int nextPP = this.i + 1;
        return new ProgramPoint(this.block, nextPP);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProgramPoint) {
            ProgramPoint other = (ProgramPoint)obj;
            return this.block.id() == other.block.id() && this.i == other.i;
        }
        return false;
    }

    public String toString() {
        List<Tree> elements;
        String tree = "";
        if (this.block instanceof CFG.Block && this.i < (elements = ((CFG.Block)this.block).elements()).size()) {
            tree = "" + (Object)((Object)elements.get(this.i).kind()) + elements.get(this.i).firstToken().line();
        }
        return "B" + this.block.id() + "." + this.i + "  " + tree;
    }

    public Tree syntaxTree() {
        if (this.block instanceof CFG.Block) {
            CFG.Block syntaxCFGblock = (CFG.Block)this.block;
            if (this.block.elements().isEmpty()) {
                return syntaxCFGblock.terminator();
            }
            return syntaxCFGblock.elements().get(Math.min(this.i, syntaxCFGblock.elements().size() - 1));
        }
        return null;
    }
}

