/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.se;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.resolve.Flags;

public class MethodLookup {
    final boolean isStatic;
    final boolean isVarArgs;
    final List<String> declaredExceptions;

    private MethodLookup(boolean isStatic, boolean isVarArgs, List<String> declaredExceptions) {
        this.isStatic = isStatic;
        this.isVarArgs = isVarArgs;
        this.declaredExceptions = declaredExceptions;
    }

    @CheckForNull
    public static MethodLookup lookup(String signature, SquidClassLoader classLoader, LookupMethodVisitor methodVisitor) {
        String className = signature.substring(0, signature.indexOf(35));
        return MethodLookup.lookup(className, signature, classLoader, methodVisitor);
    }

    private static MethodLookup lookup(String className, String signature, SquidClassLoader classLoader, LookupMethodVisitor methodVisitor) {
        MethodLookup result;
        byte[] bytes = classLoader.getBytesForClass(className);
        if (bytes == null) {
            return null;
        }
        ClassReader cr = new ClassReader(bytes);
        LookupClassVisitor lookupVisitor = new LookupClassVisitor(methodVisitor, signature);
        cr.accept((ClassVisitor)lookupVisitor, 6);
        if (lookupVisitor.methodFound) {
            return new MethodLookup(lookupVisitor.isStatic, lookupVisitor.isVarArgs, lookupVisitor.declaredExceptions);
        }
        if (lookupVisitor.superClassName != null && (result = MethodLookup.lookup(lookupVisitor.superClassName, signature, classLoader, methodVisitor)) != null) {
            return result;
        }
        if (lookupVisitor.interfaces != null) {
            return Arrays.stream(lookupVisitor.interfaces).map(iface -> MethodLookup.lookup(iface, signature, classLoader, methodVisitor)).filter(Objects::nonNull).findAny().orElse(null);
        }
        return null;
    }

    private static class LookupClassVisitor
    extends ClassVisitor {
        private final LookupMethodVisitor methodVisitor;
        private final String methodSignature;
        private boolean methodFound;
        private String superClassName;
        private String[] interfaces;
        private List<String> declaredExceptions;
        private boolean isStatic;
        private boolean isVarArgs;

        public LookupClassVisitor(LookupMethodVisitor methodVisitor, String targetedMethodSignatures) {
            super(458752);
            this.methodVisitor = methodVisitor;
            this.methodSignature = targetedMethodSignatures;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superClassName = superName;
            this.interfaces = interfaces;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals(this.methodSignature.substring(this.methodSignature.indexOf(35) + 1, this.methodSignature.indexOf(40))) && desc.equals(this.methodSignature.substring(this.methodSignature.indexOf(40)))) {
                this.methodFound = true;
                this.declaredExceptions = LookupClassVisitor.convertExceptions(exceptions);
                this.isStatic = Flags.isFlagged(access, 8);
                this.isVarArgs = Flags.isFlagged(access, 128);
                if (!this.methodVisitor.shouldVisitMethod(access, this.methodSignature)) {
                    return null;
                }
                return new JSRInlinerAdapter((MethodVisitor)this.methodVisitor, access, name, desc, signature, exceptions);
            }
            return null;
        }

        private static List<String> convertExceptions(@Nullable String[] exceptions) {
            return exceptions == null ? Collections.emptyList() : Arrays.stream(exceptions).map(Type::getObjectType).map(Type::getClassName).collect(Collectors.toList());
        }
    }

    public static class LookupMethodVisitor
    extends MethodVisitor {
        public LookupMethodVisitor() {
            super(458752);
        }

        public boolean shouldVisitMethod(int methodFlags, String methodSignature) {
            return true;
        }
    }
}

