/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.se;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.bytecode.cfg.Instruction;
import org.sonar.java.bytecode.se.BytecodeEGWalker;
import org.sonar.java.bytecode.se.BytecodeSECheck;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.MethodYield;

public class CheckerDispatcher {
    private final BytecodeEGWalker explodedGraphWalker;
    private final List<BytecodeSECheck> checks;
    Instruction currentInstruction;
    @Nullable
    MethodYield methodYield = null;
    private int currentCheckerIndex = -1;
    private boolean transition = false;

    public CheckerDispatcher(BytecodeEGWalker explodedGraphWalker, List<BytecodeSECheck> checks) {
        this.explodedGraphWalker = explodedGraphWalker;
        this.checks = checks;
    }

    public boolean executeCheckPreStatement(Instruction instruction) {
        this.currentInstruction = instruction;
        for (BytecodeSECheck checker : this.checks) {
            ProgramState ps = checker.checkPreStatement(this, instruction);
            if (ps == null) {
                return false;
            }
            this.explodedGraphWalker.programState = ps;
        }
        return true;
    }

    public void executeCheckPostStatement(Instruction instruction) {
        this.currentInstruction = instruction;
        this.addTransition(this.explodedGraphWalker.programState);
    }

    public void createSink() {
        this.transition = true;
    }

    public void addTransition(ProgramState state) {
        ProgramState oldState = this.explodedGraphWalker.programState;
        this.explodedGraphWalker.programState = state;
        ++this.currentCheckerIndex;
        this.executePost();
        --this.currentCheckerIndex;
        this.explodedGraphWalker.programState = oldState;
        this.transition = true;
    }

    private void executePost() {
        this.transition = false;
        if (this.currentCheckerIndex < this.checks.size()) {
            this.explodedGraphWalker.programState = this.checks.get(this.currentCheckerIndex).checkPostStatement(this, this.currentInstruction);
            if (this.explodedGraphWalker.programState == null) {
                return;
            }
        } else {
            this.explodedGraphWalker.enqueue(this.explodedGraphWalker.programPosition.next(), this.explodedGraphWalker.programState);
            return;
        }
        if (!this.transition) {
            this.addTransition(this.explodedGraphWalker.programState);
        }
    }

    public void addExceptionalYield(SymbolicValue target, ProgramState exceptionalState, String exceptionFullyQualifiedName, SECheck check) {
    }

    public ProgramState getState() {
        return this.explodedGraphWalker.programState;
    }

    public ExplodedGraph.Node getNode() {
        return this.explodedGraphWalker.node;
    }
}

