/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S2698")
public class AssertionsWithoutMessageCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Add a message to this assertion.";
    private static final String MESSAGE_FEST_LIKE = "Add a message to this assertion chain before the predicate method.";
    private static final String ASSERT = "assert";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String FEST_GENERIC_ASSERT = "org.fest.assertions.GenericAssert";
    private static final String ASSERTJ_ABSTRACT_ASSERT = "org.assertj.core.api.AbstractAssert";
    private static final MethodMatchers FEST_LIKE_MESSAGE_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.GenericAssert"}).names(new String[]{"as", "describedAs", "overridingErrorMessage"}).addParametersMatcher(types -> AssertionsWithoutMessageCheck.matchFirstParameterWithAnyOf(types, JAVA_LANG_STRING, "org.fest.assertions.Description")).build(), MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).names(new String[]{"as", "describedAs", "withFailMessage", "overridingErrorMessage"}).addParametersMatcher(types -> AssertionsWithoutMessageCheck.matchFirstParameterWithAnyOf(types, JAVA_LANG_STRING, "org.assertj.core.description.Description")).build()});
    private static final Set<String> ASSERT_METHODS_WITH_ONE_PARAM = SetUtils.immutableSetOf((Object[])new String[]{"assertNull", "assertNotNull"});
    private static final Set<String> ASSERT_METHODS_WITH_TWO_PARAMS = SetUtils.immutableSetOf((Object[])new String[]{"assertEquals", "assertSame", "assertNotSame", "assertThat"});
    private static final Set<String> JUNIT5_ASSERT_METHODS_IGNORED = SetUtils.immutableSetOf((Object[])new String[]{"assertAll", "assertLinesMatch"});
    private static final Set<String> JUNIT5_ASSERT_METHODS_WITH_ONE_PARAM = SetUtils.immutableSetOf((Object[])new String[]{"assertTrue", "assertFalse", "assertNull", "assertNotNull", "assertDoesNotThrow"});
    private static final Set<String> JUNIT5_ASSERT_METHODS_WITH_DELTA = SetUtils.immutableSetOf((Object[])new String[]{"assertArrayEquals", "assertEquals"});
    private static final MethodMatchers FEST_LIKE_ABSTRACT_ASSERT = MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.GenericAssert", "org.assertj.core.api.AbstractAssert"}).anyName().withAnyParameters().build();
    private static final MethodMatchers ASSERT_THAT_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.Assertions", "org.assertj.core.api.AssertionsForInterfaceTypes", "org.assertj.core.api.AssertionsForClassTypes", "org.fest.assertions.Assertions"}).names(new String[]{"assertThat", "assertThatObject"}).withAnyParameters().build();
    private static final MethodMatchers ASSERT_SETTING_CONTEXT = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).name(name -> name.startsWith("extracting") || name.startsWith("using") || name.startsWith("filtered")).withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.jupiter.api.Assertions", "org.junit.Assert", "junit.framework.Assert", "org.fest.assertions.Fail", "org.assertj.core.api.Fail"}).name(name -> name.startsWith(ASSERT) || "fail".equals(name)).withAnyParameters().build(), FEST_LIKE_ABSTRACT_ASSERT});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Symbol symbol = mit.symbol();
        Type type = symbol.owner().type();
        if (FEST_LIKE_MESSAGE_METHODS.matches(mit) || ASSERT_SETTING_CONTEXT.matches(mit)) {
            return;
        }
        IdentifierTree reportLocation = ExpressionUtils.methodName((MethodInvocationTree)mit);
        if (type.isSubtypeOf(FEST_GENERIC_ASSERT) || type.isSubtypeOf(ASSERTJ_ABSTRACT_ASSERT)) {
            this.checkFestLikeAssertion(mit, symbol, reportLocation);
        } else if (type.is("org.junit.jupiter.api.Assertions")) {
            this.checkJUnit5(mit, reportLocation);
        } else if (mit.arguments().isEmpty() || !AssertionsWithoutMessageCheck.isString((ExpressionTree)mit.arguments().get(0)) || AssertionsWithoutMessageCheck.isAssertingOnStringWithNoMessage(mit)) {
            this.reportIssue((Tree)reportLocation, MESSAGE);
        }
    }

    private void checkFestLikeAssertion(MethodInvocationTree mit, Symbol symbol, IdentifierTree reportLocation) {
        if (AssertionsWithoutMessageCheck.isConstructor(symbol)) {
            return;
        }
        if (AssertionsWithoutMessageCheck.isFirstAssertingPredicateAfterAssertThat(mit)) {
            this.reportIssue((Tree)reportLocation, MESSAGE_FEST_LIKE);
        }
    }

    private static boolean isFirstAssertingPredicateAfterAssertThat(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree childMit = (MethodInvocationTree)expression;
                if (ASSERT_THAT_MATCHER.matches(childMit)) {
                    return true;
                }
                if (ASSERT_SETTING_CONTEXT.matches(childMit)) {
                    return AssertionsWithoutMessageCheck.isFirstAssertingPredicateAfterAssertThat(childMit);
                }
            }
        }
        return false;
    }

    private void checkJUnit5(MethodInvocationTree mit, IdentifierTree reportLocation) {
        String methodName = mit.symbol().name();
        if (JUNIT5_ASSERT_METHODS_IGNORED.contains(methodName)) {
            return;
        }
        if (mit.arguments().isEmpty()) {
            this.reportIssue((Tree)reportLocation, MESSAGE);
        } else if ("fail".equals(methodName)) {
            if (mit.arguments().size() == 1 && ((ExpressionTree)mit.arguments().get(0)).symbolType().isSubtypeOf("java.lang.Throwable")) {
                this.reportIssue((Tree)reportLocation, MESSAGE);
            }
        } else {
            this.checkJUnit5Assertions(mit, reportLocation);
        }
    }

    private void checkJUnit5Assertions(MethodInvocationTree mit, IdentifierTree reportLocation) {
        Type thirdArgumentType;
        String methodName = mit.symbol().name();
        if (JUNIT5_ASSERT_METHODS_WITH_ONE_PARAM.contains(methodName)) {
            if (mit.arguments().size() == 1) {
                this.reportIssue((Tree)reportLocation, MESSAGE);
            }
        } else if (mit.arguments().size() == 2) {
            this.reportIssue((Tree)reportLocation, MESSAGE);
        } else if (JUNIT5_ASSERT_METHODS_WITH_DELTA.contains(methodName) && mit.arguments().size() == 3 && ((thirdArgumentType = ((ExpressionTree)mit.arguments().get(2)).symbolType()).isPrimitive(Type.Primitives.DOUBLE) || thirdArgumentType.isPrimitive(Type.Primitives.FLOAT))) {
            this.reportIssue((Tree)reportLocation, MESSAGE);
        }
    }

    private static Boolean matchFirstParameterWithAnyOf(List<Type> parameterTypes, String ... acceptableTypes) {
        if (!parameterTypes.isEmpty()) {
            Type firstParamType = parameterTypes.get(0);
            for (String acceptableType : acceptableTypes) {
                if (!firstParamType.is(acceptableType)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isConstructor(Symbol symbol) {
        return "<init>".equals(symbol.name());
    }

    private static boolean isAssertingOnStringWithNoMessage(MethodInvocationTree mit) {
        return AssertionsWithoutMessageCheck.isAssertWithTwoParams(mit) || AssertionsWithoutMessageCheck.isAssertWithOneParam(mit);
    }

    private static boolean isAssertWithOneParam(MethodInvocationTree mit) {
        return ASSERT_METHODS_WITH_ONE_PARAM.contains(mit.symbol().name()) && mit.arguments().size() == 1;
    }

    private static boolean isAssertWithTwoParams(MethodInvocationTree mit) {
        return ASSERT_METHODS_WITH_TWO_PARAMS.contains(mit.symbol().name()) && mit.arguments().size() == 2;
    }

    private static boolean isString(ExpressionTree expressionTree) {
        return expressionTree.symbolType().is(JAVA_LANG_STRING);
    }
}

