/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5042")
public class ZipEntryCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Make sure that expanding this archive file is safe here.";
    private static final MethodMatchers SENSITIVE_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.util.zip.ZipFile"}).names(new String[]{"entries"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.zip.ZipEntry"}).names(new String[]{"getSize"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.zip.ZipInputStream"}).names(new String[]{"getNextEntry"}).addWithoutParametersMatcher().build()});
    private static final MethodMatchers INPUT_STREAM_READ = MethodMatchers.create().ofSubTypes(new String[]{"java.io.InputStream"}).names(new String[]{"read"}).withAnyParameters().build();
    private boolean isSafe = false;
    private boolean insideMethod = false;
    private final List<MethodInvocationTree> calls = new ArrayList<MethodInvocationTree>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.isSafe = false;
            this.calls.clear();
            this.insideMethod = true;
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (this.insideMethod && INPUT_STREAM_READ.matches(mit)) {
                this.isSafe = true;
            } else if (SENSITIVE_METHODS.matches(mit)) {
                if (this.insideMethod) {
                    this.calls.add(mit);
                } else {
                    this.report(mit);
                }
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            if (!this.isSafe) {
                for (MethodInvocationTree mit : this.calls) {
                    this.report(mit);
                }
            }
            this.insideMethod = false;
        }
    }

    private void report(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), ISSUE_MESSAGE);
    }
}

