/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3329")
public class CipherBlockChainingCheck
extends AbstractMethodDetection {
    private static final MethodMatchers SECURE_RANDOM_GENERATE_SEED = MethodMatchers.create().ofTypes(new String[]{"java.security.SecureRandom"}).names(new String[]{"generateSeed"}).withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"javax.crypto.spec.IvParameterSpec"}).constructor().addParametersMatcher(types -> !types.isEmpty()).build();
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (newClassTree.arguments().isEmpty() || CipherBlockChainingCheck.isDynamicallyGenerated((ExpressionTree)newClassTree.arguments().get(0))) {
            return;
        }
        MethodTree mTree = ExpressionUtils.getEnclosingMethod((ExpressionTree)newClassTree);
        if (mTree != null) {
            MethodInvocationVisitor mitVisit = new MethodInvocationVisitor(newClassTree);
            mTree.accept((TreeVisitor)mitVisit);
            if (!mitVisit.secureRandomFound) {
                this.reportIssue((Tree)newClassTree, "Use a dynamically-generated, random IV.");
            }
        }
    }

    private static boolean isDynamicallyGenerated(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)tree).symbol();
            if (JUtils.isParameter((Symbol)symbol)) {
                return true;
            }
            VariableTree declaration = symbol.isVariableSymbol() ? ((Symbol.VariableSymbol)symbol).declaration() : null;
            return declaration != null && (CipherBlockChainingCheck.isSecureRandomGenerateSeed(declaration.initializer()) || ReassignmentFinder.getReassignments((Tree)declaration, symbol.usages()).stream().map(AssignmentExpressionTree::expression).anyMatch(CipherBlockChainingCheck::isSecureRandomGenerateSeed));
        }
        return CipherBlockChainingCheck.isSecureRandomGenerateSeed(tree);
    }

    private static boolean isSecureRandomGenerateSeed(@Nullable ExpressionTree tree) {
        return tree != null && tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && SECURE_RANDOM_GENERATE_SEED.matches((MethodInvocationTree)tree);
    }

    private static class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private boolean secureRandomFound = false;
        private final NewClassTree ivParameterSpecInstantiation;
        private final Symbol ivParameterSymbol;
        private static final MethodMatchers SECURE_RANDOM_NEXT_BYTES = MethodMatchers.create().ofTypes(new String[]{"java.security.SecureRandom"}).names(new String[]{"nextBytes"}).withAnyParameters().build();
        private static final MethodMatchers CIPHER_INIT = MethodMatchers.create().ofTypes(new String[]{"javax.crypto.Cipher"}).names(new String[]{"init"}).withAnyParameters().build();
        private static final MethodMatchers BYTEBUFFER_GET = MethodMatchers.create().ofTypes(new String[]{"java.nio.ByteBuffer"}).names(new String[]{"get"}).withAnyParameters().build();
        private static final int CIPHER_INIT_DECRYPT_MODE = 2;

        public MethodInvocationVisitor(NewClassTree newClassTree) {
            this.ivParameterSpecInstantiation = newClassTree;
            this.ivParameterSymbol = MethodInvocationVisitor.ivSymbol(newClassTree);
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            int opMode;
            Symbol initVector;
            if (SECURE_RANDOM_NEXT_BYTES.matches(methodInvocation) && !(initVector = MethodInvocationVisitor.symbol((ExpressionTree)this.ivParameterSpecInstantiation.arguments().get(0))).isUnknown() && initVector.equals(MethodInvocationVisitor.symbol((ExpressionTree)methodInvocation.arguments().get(0)))) {
                this.secureRandomFound = true;
            }
            if (CIPHER_INIT.matches(methodInvocation) && methodInvocation.arguments().size() > 2 && 2 == (opMode = ((ExpressionTree)methodInvocation.arguments().get(0)).asConstant(Integer.class).orElse(-1).intValue()) && this.isPartOfArguments(methodInvocation)) {
                this.secureRandomFound = true;
            }
            if (this.isInitVectorCopiedFromByteBuffer(methodInvocation)) {
                this.secureRandomFound = true;
            }
            super.visitMethodInvocation(methodInvocation);
        }

        private boolean isInitVectorCopiedFromByteBuffer(MethodInvocationTree methodInvocation) {
            if (!BYTEBUFFER_GET.matches(methodInvocation)) {
                return false;
            }
            Symbol initVector = MethodInvocationVisitor.symbol((ExpressionTree)this.ivParameterSpecInstantiation.arguments().get(0));
            return methodInvocation.arguments().stream().map(MethodInvocationVisitor::symbol).filter(argument -> argument.type().is("byte[]")).anyMatch(initVector::equals);
        }

        private boolean isPartOfArguments(MethodInvocationTree methodInvocation) {
            return MethodInvocationVisitor.isPartOfArguments(methodInvocation, (ExpressionTree)this.ivParameterSpecInstantiation) || !this.ivParameterSymbol.isUnknown() && MethodInvocationVisitor.isPartOfArguments(methodInvocation, this.ivParameterSymbol);
        }

        private static boolean isPartOfArguments(MethodInvocationTree methodInvocation, ExpressionTree ivParameter) {
            return methodInvocation.arguments().stream().map(ExpressionUtils::skipParentheses).anyMatch(ivParameter::equals);
        }

        private static boolean isPartOfArguments(MethodInvocationTree methodInvocation, Symbol ivParameterSymbol) {
            return methodInvocation.arguments().stream().map(ExpressionUtils::skipParentheses).map(MethodInvocationVisitor::symbol).anyMatch(ivParameterSymbol::equals);
        }

        private static Symbol symbol(ExpressionTree expression) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return ((IdentifierTree)expression).symbol();
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return ((MemberSelectExpressionTree)expression).identifier().symbol();
            }
            return Symbols.unknownSymbol;
        }

        private static Symbol ivSymbol(NewClassTree newClassTree) {
            Tree parent = newClassTree.parent();
            if (parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                return ((VariableTree)parent).symbol();
            }
            if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                return MethodInvocationVisitor.symbol(((AssignmentExpressionTree)parent).variable());
            }
            return Symbols.unknownSymbol;
        }
    }
}

