/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6300")
public class AndroidUnencryptedFilesCheck
extends AbstractMethodDetection {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.nio.file.Files"}).names(new String[]{"write"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.io.FileWriter", "java.io.FileOutputStream"}).constructor().withAnyParameters().build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIfInAndroidContext((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit));
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIfInAndroidContext((Tree)newClassTree.identifier());
    }

    private void reportIfInAndroidContext(Tree tree) {
        if (this.context.inAndroidContext()) {
            this.reportIssue(tree, "Make sure using unencrypted files is safe here.");
        }
    }
}

