/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S1190")
public class KeywordAsIdentifierCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private static final Set<String> FORBIDDEN_IDENTIFIERS = SetUtils.immutableSetOf((Object[])new String[]{"enum", "_", "assert"});

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (FORBIDDEN_IDENTIFIERS.contains(simpleName.name())) {
            this.context.reportIssue((JavaCheck)this, (Tree)simpleName, "Use a different name than \"" + simpleName.name() + "\".");
        }
        super.visitVariable(tree);
    }
}

