/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.aws;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.aws.AbstractAwsMethodVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6246")
public class AwsLambdaSyncCallCheck
extends AbstractAwsMethodVisitor {
    private static final String MESSAGE = "Avoid synchronous calls to other lambdas.";

    @Override
    void visitReachableMethodsFromHandleRequest(Set<MethodTree> methodTrees) {
        SyncInvokeFinder finder = new SyncInvokeFinder();
        methodTrees.forEach(m -> m.accept((TreeVisitor)finder));
        finder.getSyncInvokeCalls().forEach((call, msg) -> this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)call), (String)msg));
    }

    private static class SyncInvokeFinder
    extends BaseTreeVisitor {
        private final Map<MethodInvocationTree, String> invokeInvocations = new IdentityHashMap<MethodInvocationTree, String>();
        private static final MethodMatchers INVOKE_MATCHERS = MethodMatchers.create().ofSubTypes(new String[]{"com.amazonaws.services.lambda.AWSLambda"}).names(new String[]{"invoke"}).addParametersMatcher(new String[]{"com.amazonaws.services.lambda.model.InvokeRequest"}).build();
        private static final MethodMatchers INVOCATIONTYPE_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"com.amazonaws.services.lambda.model.InvokeRequest"}).names(new String[]{"setInvocationType", "withInvocationType"}).addParametersMatcher(new String[]{"java.lang.String"}).build();

        private SyncInvokeFinder() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            SyncInvokeFinder.getSyncCalls(tree).ifPresent(msgPart -> this.invokeInvocations.put(tree, (String)msgPart));
        }

        public Map<MethodInvocationTree, String> getSyncInvokeCalls() {
            return this.invokeInvocations;
        }

        private static Optional<String> getSyncCalls(MethodInvocationTree tree) {
            if (INVOKE_MATCHERS.matches(tree)) {
                ExpressionTree argument = (ExpressionTree)tree.arguments().get(0);
                if (!argument.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    return Optional.empty();
                }
                IdentifierTree invokeRequest = (IdentifierTree)argument;
                List localUsages = invokeRequest.symbol().usages().stream().filter(u -> JUtils.isLocalVariable((Symbol)u.symbol()) && !u.equals(invokeRequest)).collect(Collectors.toList());
                if (JUtils.isParameter((Symbol)invokeRequest.symbol()) || localUsages.stream().anyMatch(lu -> SyncInvokeFinder.isArgumentToACall(lu) || SyncInvokeFinder.statementSetsAsyncCall((Tree)lu)) || SyncInvokeFinder.declarationSetsAsyncCall(invokeRequest)) {
                    return Optional.empty();
                }
                if (SyncInvokeFinder.hasLocalVarDeclaration(invokeRequest)) {
                    return Optional.of(AwsLambdaSyncCallCheck.MESSAGE);
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        private static boolean isArgumentToACall(IdentifierTree invokeRequest) {
            return invokeRequest.parent() != null && invokeRequest.parent().is(new Tree.Kind[]{Tree.Kind.ARGUMENTS});
        }

        private static boolean hasLocalVarDeclaration(IdentifierTree invokeRequest) {
            Tree declaration = invokeRequest.symbol().declaration();
            return declaration != null && declaration.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && JUtils.isLocalVariable((Symbol)((VariableTree)declaration).symbol());
        }

        private static boolean statementSetsAsyncCall(Tree tree) {
            MethodInvocationTree methodCall = SyncInvokeFinder.findMethodInvocationTreeAncestor(tree);
            return methodCall != null && (SyncInvokeFinder.setsInvocationTypeToAsync(methodCall) || SyncInvokeFinder.statementSetsAsyncCall((Tree)methodCall));
        }

        private static MethodInvocationTree findMethodInvocationTreeAncestor(Tree tree) {
            for (Tree parent = tree.parent(); parent != null; parent = parent.parent()) {
                if (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) continue;
                return (MethodInvocationTree)parent;
            }
            return null;
        }

        private static boolean declarationSetsAsyncCall(IdentifierTree invokeRequest) {
            Tree declaration = invokeRequest.symbol().declaration();
            if (declaration == null) {
                return true;
            }
            AsyncInvocationTypeSetterFinder asyncSetterVisitor = new AsyncInvocationTypeSetterFinder();
            declaration.accept((TreeVisitor)asyncSetterVisitor);
            return asyncSetterVisitor.found();
        }

        private static boolean setsInvocationTypeToAsync(MethodInvocationTree methodCall) {
            Arguments arguments = methodCall.arguments();
            if (INVOCATIONTYPE_MATCHERS.matches(methodCall)) {
                String stringVal = ExpressionsHelper.getConstantValueAsString((ExpressionTree)arguments.get(0)).value();
                return "Event".equals(stringVal) || "DryRun".equals(stringVal) || stringVal == null;
            }
            return false;
        }

        private static final class AsyncInvocationTypeSetterFinder
        extends BaseTreeVisitor {
            private boolean found = false;

            private AsyncInvocationTypeSetterFinder() {
            }

            public void visitMethodInvocation(MethodInvocationTree methodCall) {
                this.found = this.found || SyncInvokeFinder.setsInvocationTypeToAsync(methodCall);
            }

            public boolean found() {
                return this.found;
            }
        }
    }
}

