/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5663")
public class SimpleStringLiteralForSingleLineStringsCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Use simple literal for a single-line string.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TEXT_BLOCK);
    }

    public void visitNode(Tree tree) {
        LiteralTree textBlock = (LiteralTree)tree;
        String value = textBlock.value();
        if (value.split("(\r?\n)|\r").length <= 2) {
            this.reportIssue(tree, MESSAGE);
        }
    }
}

