/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1168")
public class ReturnEmptyArrayNotNullCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers ITEM_PROCESSOR_PROCESS_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.batch.item.ItemProcessor"}).names(new String[]{"process"}).withAnyParameters().build();
    private final Deque<ReturnKind> returnKinds = new LinkedList<ReturnKind>();
    private QuickFixHelper.ImportSupplier importSupplier;

    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.reset();
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.reset();
    }

    private void reset() {
        this.returnKinds.clear();
        this.importSupplier = null;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR, Tree.Kind.RETURN_STATEMENT, Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree methodTree = (MethodTree)tree;
            SymbolMetadata metadata = methodTree.symbol().metadata();
            if (metadata.nullabilityData().isNullable(SymbolMetadata.NullabilityLevel.PACKAGE, false, true) || ReturnEmptyArrayNotNullCheck.requiresReturnNull(methodTree)) {
                this.returnKinds.push(ReturnKind.OTHER);
            } else {
                this.returnKinds.push(ReturnKind.forType(methodTree.returnType().symbolType()));
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR, Tree.Kind.LAMBDA_EXPRESSION})) {
            this.returnKinds.push(ReturnKind.OTHER);
        } else {
            this.checkForIssue((ReturnStatementTree)tree);
        }
    }

    private void checkForIssue(ReturnStatementTree returnStatement) {
        if (!ReturnEmptyArrayNotNullCheck.isReturningNull(returnStatement)) {
            return;
        }
        ReturnKind returnKind = this.returnKinds.peek();
        if (returnKind.kind == Returns.OTHER) {
            return;
        }
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)returnStatement.expression()).withMessage("Return an empty %s instead of null.", new Object[]{returnKind.kind.name().toLowerCase(Locale.ROOT)}).withQuickFixes(() -> this.quickFix(returnStatement)).report();
    }

    public void leaveNode(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.returnKinds.pop();
        }
    }

    private static boolean isReturningNull(ReturnStatementTree tree) {
        ExpressionTree expression = tree.expression();
        return expression != null && expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private static boolean requiresReturnNull(MethodTree methodTree) {
        Symbol owner = methodTree.symbol().owner();
        if (owner == null || !owner.isTypeSymbol()) {
            return true;
        }
        List interfaces = ((Symbol.TypeSymbol)owner).interfaces();
        return ReturnEmptyArrayNotNullCheck.isOverriding(methodTree) && (interfaces.stream().anyMatch(Type::isUnknown) || ITEM_PROCESSOR_PROCESS_METHOD.matches(methodTree));
    }

    private static boolean isOverriding(MethodTree tree) {
        return Boolean.TRUE.equals(tree.isOverriding());
    }

    private List<JavaQuickFix> quickFix(ReturnStatementTree returnStatement) {
        ReturnKind returnKind = this.returnKinds.peek();
        if (returnKind.kind == Returns.ARRAY) {
            return Collections.singletonList(JavaQuickFix.newQuickFix((String)"Replace \"null\" with an empty array").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)returnStatement.expression(), (String)ReturnEmptyArrayNotNullCheck.emptyArrayString((Type.ArrayType)returnKind.type))}).build());
        }
        Optional<CollectionType> candidate = CollectionType.forType(returnKind.type);
        if (!candidate.isPresent()) {
            return Collections.emptyList();
        }
        CollectionType collectionType = candidate.get();
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix((String)"Replace \"null\" with an empty %s", (Object[])new Object[]{collectionType.typeName}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)returnStatement.expression(), (String)collectionType.replacement)});
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        this.importSupplier.newImportEdit(collectionType.requiredType).ifPresent(xva$0 -> builder.addTextEdit(new JavaTextEdit[]{xva$0}));
        return Collections.singletonList(builder.build());
    }

    private static String emptyArrayString(Type.ArrayType arrayType) {
        return String.format("new %s", arrayType.name().replace("[]", "[0]").replaceAll("<.+>", ""));
    }

    private static class ReturnKind {
        private static final ReturnKind OTHER = new ReturnKind(Returns.OTHER, null);
        private final Returns kind;
        @Nullable
        private final Type type;

        private ReturnKind(Returns kind, @Nullable Type type) {
            this.kind = kind;
            this.type = type;
        }

        public static ReturnKind forType(Type type) {
            if (type.isUnknown()) {
                return OTHER;
            }
            if (type.isArray()) {
                return new ReturnKind(Returns.ARRAY, type);
            }
            if (type.isSubtypeOf("java.util.Collection")) {
                return new ReturnKind(Returns.COLLECTION, type);
            }
            if (type.isSubtypeOf("java.util.Map")) {
                return new ReturnKind(Returns.MAP, type);
            }
            return OTHER;
        }
    }

    private static enum Returns {
        ARRAY,
        COLLECTION,
        MAP,
        OTHER;

    }

    private static enum CollectionType {
        COLLECTION("Collection", "Collections.emptyList()"),
        LIST("List", "Collections.emptyList()"),
        ARRAY_LIST("ArrayList"),
        LINKED_LIST("LinkedList"),
        SET("Set", "Collections.emptySet()"),
        HASH_SET("HashSet"),
        TREE_SET("TreeSet"),
        SORTED_SET("SortedSet", "Collections.emptySortedSet()"),
        NAVIGABLE_SET("NavigableSet", "Collections.emptyNavigableSet()"),
        MAP("Map", "Collections.emptyMap()"),
        HASH_MAP("HashMap"),
        TREE_MAP("TreeMap"),
        SORTED_MAP("SortedMap", "Collections.emptySortedMap()"),
        NAVIGABLE_MAP("NavigableMap", "Collections.emptyNavigableMap()");

        private final String fullyQualifiedName;
        private final String replacement;
        private final String typeName;
        private final String requiredType;

        private CollectionType(String typeName) {
            this.typeName = typeName;
            this.replacement = String.format("new %s<>()", typeName);
            this.requiredType = this.fullyQualifiedName = String.format("java.util.%s", typeName);
        }

        private CollectionType(String typeName, String replacement) {
            this.typeName = typeName;
            this.replacement = replacement;
            this.fullyQualifiedName = String.format("java.util.%s", typeName);
            this.requiredType = "java.util.Collections";
        }

        private static Optional<CollectionType> forType(Type type) {
            Type erasure = type.erasure();
            for (CollectionType collectionType : CollectionType.values()) {
                if (!erasure.is(collectionType.fullyQualifiedName)) continue;
                return Optional.of(collectionType);
            }
            return Optional.empty();
        }
    }
}

