/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@DeprecatedRuleKey(ruleKey="ObjectFinalizeOverridenCallsSuperFinalizeCheck", repositoryKey="squid")
@Rule(key="S1114")
public class ObjectFinalizeOverridenCallsSuperFinalizeCheck
extends IssuableSubscriptionVisitor {
    private static final String FINALIZE = "finalize";
    private static final MethodMatchers FINALIZE_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"finalize"}).addWithoutParametersMatcher().build();
    private MethodInvocationTree lastStatementTree;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MemberSelectExpressionTree mset;
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            if (methodInvocationTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && FINALIZE.equals((mset = (MemberSelectExpressionTree)methodInvocationTree.methodSelect()).identifier().name()) && mset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "super".equals(((IdentifierTree)mset.expression()).name())) {
                this.lastStatementTree = methodInvocationTree;
            }
        } else if (FINALIZE_MATCHER.matches((MethodTree)tree)) {
            this.lastStatementTree = null;
        }
    }

    public void leaveNode(Tree tree) {
        MethodTree methodTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && FINALIZE_MATCHER.matches(methodTree = (MethodTree)tree) && ObjectFinalizeOverridenCallsSuperFinalizeCheck.doesOverrideFinalize(methodTree.symbol().owner())) {
            if (this.lastStatementTree == null) {
                this.reportIssue((Tree)methodTree.simpleName(), "Add a call to super.finalize() at the end of this Object.finalize() implementation.");
            } else if (!ObjectFinalizeOverridenCallsSuperFinalizeCheck.isLastStatement(methodTree, this.lastStatementTree)) {
                this.reportIssue((Tree)this.lastStatementTree, "Move this super.finalize() call to the end of this Object.finalize() implementation.");
            }
        }
    }

    private static boolean isLastStatement(MethodTree methodTree, MethodInvocationTree lastStatementTree) {
        BlockTree blockTree = methodTree.block();
        if (blockTree != null && blockTree.body().stream().anyMatch(statement -> statement.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}) && ObjectFinalizeOverridenCallsSuperFinalizeCheck.isLastStatement(((TryStatementTree)statement).finallyBlock(), lastStatementTree))) {
            return true;
        }
        return ObjectFinalizeOverridenCallsSuperFinalizeCheck.isLastStatement(blockTree, lastStatementTree);
    }

    private static boolean isLastStatement(@Nullable BlockTree blockTree, MethodInvocationTree lastStatementTree) {
        if (blockTree != null) {
            StatementTree last = (StatementTree)ListUtils.getLast((List)blockTree.body());
            if (last.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                return lastStatementTree.equals(((ExpressionStatementTree)last).expression());
            }
            if (last.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
                return ObjectFinalizeOverridenCallsSuperFinalizeCheck.isLastStatement(((TryStatementTree)last).finallyBlock(), lastStatementTree);
            }
        }
        return false;
    }

    private static boolean doesOverrideFinalize(Symbol classSymbol) {
        if (classSymbol.isTypeSymbol()) {
            Type superClassType = ((Symbol.TypeSymbol)classSymbol).superClass();
            while (superClassType != null && !superClassType.is("java.lang.Object")) {
                Symbol.TypeSymbol currentClass = superClassType.symbol();
                if (currentClass.lookupSymbols(FINALIZE).stream().anyMatch(arg_0 -> ((MethodMatchers)FINALIZE_MATCHER).matches(arg_0))) {
                    return true;
                }
                superClassType = currentClass.superClass();
            }
        }
        return false;
    }
}

