/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SwitchTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1821")
public class NestedSwitchCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.SWITCH_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        NestedSwitchVisitor visitor = new NestedSwitchVisitor();
        ((SwitchTree)tree).cases().forEach(c -> c.accept((TreeVisitor)visitor));
    }

    private class NestedSwitchVisitor
    extends BaseTreeVisitor {
        private NestedSwitchVisitor() {
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitSwitchStatement(SwitchStatementTree tree) {
            this.reportNestedSwitch((SwitchTree)tree);
        }

        public void visitSwitchExpression(SwitchExpressionTree tree) {
            this.reportNestedSwitch((SwitchTree)tree);
        }

        private void reportNestedSwitch(SwitchTree switchTree) {
            NestedSwitchCheck.this.reportIssue((Tree)switchTree.switchKeyword(), "Refactor the code to eliminate this nested \"switch\".");
        }
    }
}

