/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3047")
public class LoopsOnSameSetCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.BLOCK);
    }

    public void visitNode(Tree tree) {
        HashMap<Symbol, Integer> forEachSymbols = new HashMap<Symbol, Integer>();
        ExpressionTree previousForeachIterable = null;
        for (StatementTree item : ((BlockTree)tree).body()) {
            if (item.is(new Tree.Kind[]{Tree.Kind.FOR_EACH_STATEMENT})) {
                ForEachStatement forEachStatement = (ForEachStatement)item;
                this.checkForEach((Map<Symbol, Integer>)forEachSymbols, (Tree)previousForeachIterable, forEachStatement);
                previousForeachIterable = forEachStatement.expression();
                continue;
            }
            previousForeachIterable = null;
            item.accept((TreeVisitor)new InvalidatorVisitor(forEachSymbols));
        }
    }

    private void checkForEach(Map<Symbol, Integer> forEachSymbols, @Nullable Tree previousIterable, ForEachStatement item) {
        ExpressionTree expressionTree = ExpressionUtils.skipParentheses((ExpressionTree)item.expression());
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.checkForEachIdentifier(forEachSymbols, (IdentifierTree)expressionTree);
        } else if (previousIterable != null) {
            this.checkForEachExpression(previousIterable, expressionTree);
        }
    }

    private void checkForEachExpression(Tree forEachIterable, ExpressionTree expressionTree) {
        if (SyntacticEquivalence.areEquivalent((Tree)expressionTree, (Tree)forEachIterable)) {
            this.addIssue((Tree)expressionTree, forEachIterable.firstToken().range().start().line());
        }
    }

    private void checkForEachIdentifier(Map<Symbol, Integer> forEachSymbols, IdentifierTree node) {
        Symbol symbol = node.symbol();
        if (symbol.owner().isMethodSymbol()) {
            if (forEachSymbols.containsKey(symbol)) {
                this.addIssue((Tree)node, forEachSymbols.get(symbol));
            } else {
                forEachSymbols.put(symbol, ((JavaTree)node).getLine());
            }
        }
    }

    private void addIssue(Tree tree, int line) {
        this.reportIssue(tree, "Combine this loop with the one that starts on line " + line + ".");
    }

    private static class InvalidatorVisitor
    extends BaseTreeVisitor {
        private final Map<Symbol, Integer> forEachSymbols;

        InvalidatorVisitor(Map<Symbol, Integer> forEachSymbols) {
            this.forEachSymbols = forEachSymbols;
        }

        public void visitIdentifier(IdentifierTree tree) {
            Symbol symbol = tree.symbol();
            if (this.forEachSymbols.containsKey(symbol)) {
                this.forEachSymbols.remove(symbol);
            }
            super.visitIdentifier(tree);
        }
    }
}

