/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2139")
public class LoggedRethrownExceptionsCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_UTIL_LOGGING_LOGGER = "java.util.logging.Logger";
    private static final String SLF4J_LOGGER = "org.slf4j.Logger";
    private static final MethodMatchers LOGGING_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"config", "info", "log", "logp", "logrb", "throwing", "severe", "warning"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.slf4j.Logger"}).names(new String[]{"debug", "error", "info", "trace", "warn"}).withAnyParameters().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CATCH);
    }

    public void visitNode(Tree tree) {
        CatchTree catchTree = (CatchTree)tree;
        boolean isLogging = false;
        ArrayList<JavaFileScannerContext.Location> secondaryLocations = new ArrayList<JavaFileScannerContext.Location>();
        for (StatementTree statementTree : catchTree.block().body()) {
            IdentifierTree exceptionIdentifier = catchTree.parameter().simpleName();
            if (isLogging && statementTree.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT}) && LoggedRethrownExceptionsCheck.isExceptionUsed(exceptionIdentifier, ((ThrowStatementTree)statementTree).expression())) {
                secondaryLocations.add(new JavaFileScannerContext.Location("Thrown exception.", (Tree)((ThrowStatementTree)statementTree).expression()));
                this.reportIssue((Tree)catchTree.parameter(), "Either log this exception and handle it, or rethrow it with some contextual information.", secondaryLocations, 0);
                return;
            }
            if (!LoggedRethrownExceptionsCheck.isLoggingMethod(statementTree, exceptionIdentifier)) continue;
            secondaryLocations.add(new JavaFileScannerContext.Location("Logging statement.", (Tree)statementTree));
            isLogging = true;
        }
    }

    private static boolean isLoggingMethod(StatementTree statementTree, IdentifierTree exceptionIdentifier) {
        if (!statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            return false;
        }
        ExpressionTree expression = ((ExpressionStatementTree)statementTree).expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expression;
            return LOGGING_METHODS.matches(mit) && LoggedRethrownExceptionsCheck.isExceptionUsed(exceptionIdentifier, mit);
        }
        return false;
    }

    private static boolean isExceptionUsed(IdentifierTree exceptionIdentifier, MethodInvocationTree mit) {
        ExceptionUsageVisitor visitor = new ExceptionUsageVisitor(exceptionIdentifier);
        mit.arguments().forEach(param -> param.accept((TreeVisitor)visitor));
        return visitor.isExceptionIdentifierUsed;
    }

    private static boolean isExceptionUsed(IdentifierTree exceptionIdentifier, ExpressionTree expressionTree) {
        ExceptionUsageVisitor visitor = new ExceptionUsageVisitor(exceptionIdentifier);
        expressionTree.accept((TreeVisitor)visitor);
        return visitor.isExceptionIdentifierUsed;
    }

    private static class ExceptionUsageVisitor
    extends BaseTreeVisitor {
        IdentifierTree exceptionIdentifier;
        boolean isExceptionIdentifierUsed = false;

        ExceptionUsageVisitor(IdentifierTree exceptionIdentifier) {
            this.exceptionIdentifier = exceptionIdentifier;
        }

        public void visitIdentifier(IdentifierTree tree) {
            if (!this.isExceptionIdentifierUsed && tree.name().equals(this.exceptionIdentifier.name())) {
                this.isExceptionIdentifierUsed = true;
            }
        }
    }
}

