/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1602")
public class LambdaSingleExpressionCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
        Tree lambdaBody = lambdaExpressionTree.body();
        if (LambdaSingleExpressionCheck.isBlockWithOneStatement(lambdaBody)) {
            Object message = "Remove useless curly braces around statement";
            if (LambdaSingleExpressionCheck.singleStatementIsReturn(lambdaExpressionTree)) {
                message = (String)message + " and then remove useless return keyword";
            }
            this.reportIssue((Tree)((BlockTree)lambdaBody).openBraceToken(), (String)message + this.context.getJavaVersion().java8CompatibilityMessage());
        }
    }

    private static boolean isBlockWithOneStatement(Tree tree) {
        boolean result = false;
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            List blockBody = ((BlockTree)tree).body();
            result = blockBody.size() == 1 && LambdaSingleExpressionCheck.isRefactorizable((StatementTree)blockBody.get(0));
        }
        return result;
    }

    private static boolean isRefactorizable(StatementTree statementTree) {
        return LambdaSingleExpressionCheck.isBlockWithOneStatement((Tree)statementTree) || statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) || LambdaSingleExpressionCheck.isReturnStatement((Tree)statementTree);
    }

    private static boolean singleStatementIsReturn(LambdaExpressionTree lambdaExpressionTree) {
        return LambdaSingleExpressionCheck.isReturnStatement((Tree)((BlockTree)lambdaExpressionTree.body()).body().get(0));
    }

    private static boolean isReturnStatement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT});
    }
}

