/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2176")
public class InterfaceOrSuperclassShadowingCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        this.checkSuperType(classTree, classSymbol.superClass());
        for (Type interfaceType : classSymbol.interfaces()) {
            this.checkSuperType(classTree, interfaceType);
        }
    }

    private void checkSuperType(ClassTree tree, @Nullable Type superType) {
        if (superType != null && InterfaceOrSuperclassShadowingCheck.hasSameName(tree, superType) && !InterfaceOrSuperclassShadowingCheck.isInnerClass(tree)) {
            this.reportIssue((Tree)tree.simpleName(), "Rename this " + tree.kind().name().toLowerCase(Locale.ROOT) + ".");
        }
    }

    private static boolean hasSameName(ClassTree tree, Type superType) {
        return superType.symbol().name().equals(tree.symbol().name());
    }

    private static boolean isInnerClass(ClassTree tree) {
        Symbol owner = tree.symbol().owner();
        return owner != null && !owner.isUnknown() && owner.isTypeSymbol();
    }
}

