/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2694")
public class InnerStaticClassesCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<Symbol> outerClasses = new LinkedList<Symbol>();
    private Deque<Boolean> atLeastOneReference = new LinkedList<Boolean>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            return;
        }
        Symbol.TypeSymbol symbol = tree.symbol();
        this.outerClasses.push((Symbol)symbol);
        this.atLeastOneReference.push(Boolean.FALSE);
        this.scan(tree.members());
        Boolean oneReference = this.atLeastOneReference.pop();
        this.outerClasses.pop();
        if (!symbol.isStatic() && !Boolean.TRUE.equals(oneReference) && !InnerStaticClassesCheck.isParameterizedWithTypeVarFromParent(tree) && this.couldBeDeclaredStatic(symbol)) {
            IdentifierTree reportTree = tree.simpleName();
            if (reportTree == null) {
                return;
            }
            String message = "Make this a \"static\" inner class.";
            if (symbol.owner().isMethodSymbol()) {
                message = "Make this local class a \"static\" inner class.";
            }
            this.context.reportIssue((JavaCheck)this, (Tree)reportTree, message);
        }
    }

    private boolean couldBeDeclaredStatic(Symbol.TypeSymbol symbol) {
        Symbol.TypeSymbol superClassSymbol;
        Type superClass = symbol.superClass();
        if (superClass != null && !(superClassSymbol = superClass.symbol()).owner().isPackageSymbol() && !superClassSymbol.isStatic()) {
            return false;
        }
        if (this.outerClasses.size() == 1) {
            return true;
        }
        for (Symbol outerClass : this.outerClasses) {
            if (!outerClass.isStatic()) continue;
            return true;
        }
        return false;
    }

    private static boolean isParameterizedWithTypeVarFromParent(ClassTree tree) {
        if (!tree.typeParameters().isEmpty()) {
            return false;
        }
        LinkedList<ParameterizedTypeTree> parameterizedSuperTypes = new LinkedList<ParameterizedTypeTree>();
        TypeTree superClass = tree.superClass();
        if (superClass != null && superClass.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            parameterizedSuperTypes.add((ParameterizedTypeTree)superClass);
        }
        for (TypeTree typeTree : tree.superInterfaces()) {
            if (!typeTree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) continue;
            parameterizedSuperTypes.add((ParameterizedTypeTree)typeTree);
        }
        return parameterizedSuperTypes.stream().flatMap(parameterizedTypeTree -> parameterizedTypeTree.typeArguments().stream()).map(TypeTree::symbolType).anyMatch(JUtils::isTypeVar);
    }

    public void visitIdentifier(IdentifierTree tree) {
        super.visitIdentifier(tree);
        this.checkSymbol(tree.symbol());
    }

    public void visitNewClass(NewClassTree tree) {
        super.visitNewClass(tree);
        this.checkSymbol((Symbol)tree.symbolType().symbol());
    }

    private void checkSymbol(Symbol symbol) {
        int level;
        if (!this.atLeastOneReference.isEmpty() && (level = this.referenceInstance(symbol)) >= 0) {
            for (int i = 0; i < level; ++i) {
                this.atLeastOneReference.pop();
            }
            while (this.atLeastOneReference.size() != this.outerClasses.size()) {
                this.atLeastOneReference.push(Boolean.TRUE);
            }
        }
    }

    private int referenceInstance(Symbol symbol) {
        Symbol owner = symbol.owner();
        if (owner != null && owner.isMethodSymbol()) {
            owner = owner.owner();
        }
        int result = -1;
        if (owner != null && !this.outerClasses.peek().equals(owner)) {
            if (symbol.isUnknown()) {
                result = this.atLeastOneReference.size() - 1;
            } else if (!symbol.isStatic()) {
                result = this.fromInstance(symbol, owner);
            }
        }
        return result;
    }

    private int fromInstance(Symbol symbol, Symbol owner) {
        int i = -1;
        Type ownerType = owner.type();
        for (Symbol outerClass : this.outerClasses) {
            ++i;
            if (!symbol.equals(outerClass) && (ownerType == null || !owner.isTypeSymbol() || !outerClass.type().isSubtypeOf(ownerType))) continue;
            return i;
        }
        return -1;
    }

    public void visitVariable(VariableTree tree) {
        Symbol symbol = tree.symbol();
        if (symbol != null && !symbol.isStatic()) {
            this.scan((ListTree)tree.modifiers());
            this.scan((Tree)tree.type());
            this.scan((Tree)tree.initializer());
        }
    }

    public void visitMethod(MethodTree tree) {
        this.scan((ListTree)tree.modifiers());
        this.scan((ListTree)tree.typeParameters());
        this.scan((Tree)tree.returnType());
        this.scan(tree.parameters());
        this.scan((Tree)tree.defaultValue());
        this.scan(tree.throwsClauses());
        this.scan((Tree)tree.block());
    }
}

