/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1871")
public class IdenticalCasesInSwitchCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.SWITCH_EXPRESSION, Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree node) {
        if (node.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT, Tree.Kind.SWITCH_EXPRESSION})) {
            boolean allBranchesSameWithoutDefault;
            SwitchTree switchTree = (SwitchTree)node;
            Map<CaseGroupTree, Set<CaseGroupTree>> identicalBranches = this.checkSwitchStatement(switchTree);
            boolean allBranchesSame = IdenticalCasesInSwitchCheck.allBranchesSame(identicalBranches, switchTree.cases().size());
            boolean bl = allBranchesSameWithoutDefault = allBranchesSame && !IdenticalCasesInSwitchCheck.hasDefaultClause(switchTree);
            if (!allBranchesSame || allBranchesSameWithoutDefault) {
                identicalBranches.forEach((first, others) -> {
                    if (!IdenticalCasesInSwitchCheck.isTrivialCase(first.body()) || allBranchesSameWithoutDefault) {
                        others.forEach(other -> this.createIssue((Tree)other, IdenticalCasesInSwitchCheck.issueMessage("case", (Tree)first), (Tree)first));
                    }
                });
            }
        } else if (node.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && !node.parent().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatement = (IfStatementTree)node;
            IfElseChain ifElseChain = IdenticalCasesInSwitchCheck.checkIfStatement(ifStatement);
            this.reportIdenticalIfChainBranches(ifElseChain.branches, ifElseChain.totalBranchCount, IdenticalCasesInSwitchCheck.hasElseClause(ifStatement));
        }
    }

    protected static boolean allBranchesSame(Map<? extends Tree, ? extends Set<? extends Tree>> identicalBranches, int size) {
        return identicalBranches.keySet().size() == 1 && IdenticalCasesInSwitchCheck.identicalBranchesSize(identicalBranches) == (long)(size - 1);
    }

    private static long identicalBranchesSize(Map<? extends Tree, ? extends Set<? extends Tree>> identicalBranches) {
        return identicalBranches.values().stream().flatMap(Collection::stream).count();
    }

    private static boolean isTrivialCase(List<StatementTree> body) {
        return body.size() == 1 || body.size() == 2 && body.get(1).is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT});
    }

    protected Map<CaseGroupTree, Set<CaseGroupTree>> checkSwitchStatement(SwitchTree node) {
        HashMap<CaseGroupTree, Set<CaseGroupTree>> identicalBranches = new HashMap<CaseGroupTree, Set<CaseGroupTree>>();
        int index = 0;
        List cases = node.cases();
        HashSet<CaseGroupTree> duplicates = new HashSet<CaseGroupTree>();
        for (CaseGroupTree caseGroupTree : cases) {
            ++index;
            if (duplicates.contains(caseGroupTree)) continue;
            for (int i = index; i < cases.size(); ++i) {
                CaseGroupTree caseI = (CaseGroupTree)cases.get(i);
                if (!SyntacticEquivalence.areEquivalent((List)caseGroupTree.body(), (List)caseI.body())) continue;
                duplicates.add(caseI);
                identicalBranches.computeIfAbsent(caseGroupTree, k -> new HashSet()).add(caseI);
            }
        }
        return identicalBranches;
    }

    protected static IfElseChain checkIfStatement(IfStatementTree node) {
        IfElseChain ifElseChain = new IfElseChain();
        ifElseChain.totalBranchCount = 1;
        ArrayList<StatementTree> allBranches = new ArrayList<StatementTree>();
        allBranches.add(node.thenStatement());
        StatementTree elseStatement = node.elseStatement();
        while (elseStatement != null && elseStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatement = (IfStatementTree)elseStatement;
            allBranches.add(ifStatement.thenStatement());
            elseStatement = ifStatement.elseStatement();
        }
        if (elseStatement != null) {
            allBranches.add(elseStatement);
        }
        return IdenticalCasesInSwitchCheck.collectIdenticalBranches(allBranches);
    }

    private static IfElseChain collectIdenticalBranches(List<StatementTree> allBranches) {
        IfElseChain ifElseChain = new IfElseChain();
        HashSet<StatementTree> duplicates = new HashSet<StatementTree>();
        for (int i = 0; i < allBranches.size(); ++i) {
            if (duplicates.contains(allBranches.get(i))) continue;
            for (int j = i + 1; j < allBranches.size(); ++j) {
                StatementTree statement2;
                StatementTree statement1 = allBranches.get(i);
                if (!SyntacticEquivalence.areEquivalent((Tree)statement1, (Tree)(statement2 = allBranches.get(j)))) continue;
                duplicates.add(statement2);
                ifElseChain.branches.computeIfAbsent(statement1, k -> new HashSet()).add(statement2);
            }
        }
        ifElseChain.totalBranchCount = allBranches.size();
        return ifElseChain;
    }

    private void reportIdenticalIfChainBranches(Map<StatementTree, Set<StatementTree>> identicalBranches, int totalBranchCount, boolean withElseClause) {
        boolean allBranchesSameWithoutElse;
        boolean allBranchesSame = IdenticalCasesInSwitchCheck.allBranchesSame(identicalBranches, totalBranchCount);
        boolean bl = allBranchesSameWithoutElse = allBranchesSame && !withElseClause;
        if (!allBranchesSame || allBranchesSameWithoutElse) {
            identicalBranches.forEach((first, others) -> {
                if (!IdenticalCasesInSwitchCheck.isTrivialIfStatement(first) || allBranchesSameWithoutElse) {
                    others.forEach(other -> this.createIssue((Tree)other, IdenticalCasesInSwitchCheck.issueMessage("branch", (Tree)first), (Tree)first));
                }
            });
        }
    }

    private static boolean isTrivialIfStatement(StatementTree node) {
        return !node.is(new Tree.Kind[]{Tree.Kind.BLOCK}) || ((BlockTree)node).body().size() <= 1;
    }

    protected static boolean hasDefaultClause(SwitchTree switchStatement) {
        return switchStatement.cases().stream().flatMap(caseGroupTree -> caseGroupTree.labels().stream()).anyMatch(caseLabelTree -> "default".equals(caseLabelTree.caseOrDefaultKeyword().text()));
    }

    protected static boolean hasElseClause(IfStatementTree ifStatement) {
        StatementTree elseStatement = ifStatement.elseStatement();
        while (elseStatement != null && elseStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            elseStatement = ((IfStatementTree)elseStatement).elseStatement();
        }
        return elseStatement != null;
    }

    private void createIssue(Tree node, String message, Tree secondary) {
        this.reportIssue(node, message, Collections.singletonList(new JavaFileScannerContext.Location("Original", secondary)), null);
    }

    private static String issueMessage(String type, Tree node) {
        return "This " + type + "'s code block is the same as the block for the " + type + " on line " + node.firstToken().range().start().line() + ".";
    }

    protected static class IfElseChain {
        Map<StatementTree, Set<StatementTree>> branches = new HashMap<StatementTree, Set<StatementTree>>();
        int totalBranchCount;

        protected IfElseChain() {
        }
    }
}

