/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S3725")
public class FilesExistsJDK8Check
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String JAVA_NIO_FILE_FILES = "java.nio.file.Files";
    private static final String EXISTS = "exists";
    private static final String IS_DIRECTORY = "isDirectory";
    private static final Map<String, String> messageParam = MapBuilder.newMap().put((Object)"exists", (Object)"exists").put((Object)"notExists", (Object)"exists").put((Object)"isRegularFile", (Object)"isFile").put((Object)"isDirectory", (Object)"isDirectory").build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.asInt() == 8;
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{JAVA_NIO_FILE_FILES}).names(new String[]{EXISTS, "notExists", "isRegularFile", IS_DIRECTORY}).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Replace this with a call to the \"toFile()." + messageParam.get(methodName) + "()\" method");
    }

    @Override
    protected void onMethodReferenceFound(MethodReferenceTree methodReferenceTree) {
        String methodName = methodReferenceTree.method().symbol().name();
        this.reportIssue((Tree)methodReferenceTree.method(), "Replace this with a call to the \"toFile()." + messageParam.get(methodName) + "()\" method");
    }
}

