/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2160")
public class EqualsNotOverriddenInSubclassCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers EQUALS_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (EqualsNotOverriddenInSubclassCheck.shouldImplementEquals(classTree)) {
            this.reportIssue((Tree)classTree.simpleName(), "Override the \"equals\" method in this class.");
        }
    }

    private static boolean shouldImplementEquals(ClassTree classTree) {
        return EqualsNotOverriddenInSubclassCheck.hasAtLeastOneField(classTree) && !EqualsNotOverriddenInSubclassCheck.hasEqualsMethod(classTree.symbol()) && EqualsNotOverriddenInSubclassCheck.parentClassImplementsEquals(classTree);
    }

    private static boolean hasAtLeastOneField(ClassTree classTree) {
        return classTree.members().stream().anyMatch(EqualsNotOverriddenInSubclassCheck::isField);
    }

    private static boolean isField(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && !ModifiersUtils.hasModifier((ModifiersTree)((VariableTree)tree).modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean parentClassImplementsEquals(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        if (superClass != null) {
            Type superClassType = superClass.symbolType();
            while (superClassType.symbol().isTypeSymbol() && !superClassType.is("java.lang.Object")) {
                Symbol.TypeSymbol superClassSymbol = superClassType.symbol();
                Optional<Symbol> equalsMethod = EqualsNotOverriddenInSubclassCheck.equalsMethod(superClassSymbol);
                if (equalsMethod.isPresent()) {
                    Symbol equalsMethodSymbol = equalsMethod.get();
                    return !equalsMethodSymbol.isFinal() && !equalsMethodSymbol.isAbstract();
                }
                superClassType = superClassSymbol.superClass();
            }
        }
        return false;
    }

    private static boolean hasEqualsMethod(Symbol.TypeSymbol type) {
        return EqualsNotOverriddenInSubclassCheck.equalsMethod(type).isPresent();
    }

    private static Optional<Symbol> equalsMethod(Symbol.TypeSymbol type) {
        return type.lookupSymbols("equals").stream().filter(arg_0 -> ((MethodMatchers)EQUALS_MATCHER).matches(arg_0)).findFirst();
    }
}

