/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.apache.commons.lang3.StringUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;

public class CommentContainsPatternChecker {
    private final IssuableSubscriptionVisitor newCheck;
    private final String pattern;
    private final String message;

    public CommentContainsPatternChecker(IssuableSubscriptionVisitor check, String pattern, String message) {
        this.newCheck = check;
        this.pattern = pattern;
        this.message = message;
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase((CharSequence)line, (CharSequence)pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }

    public void checkTrivia(SyntaxTrivia syntaxTrivia) {
        String comment = syntaxTrivia.comment();
        if (StringUtils.containsIgnoreCase((CharSequence)comment, (CharSequence)this.pattern)) {
            String[] lines = comment.split("\r\n?|\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!StringUtils.containsIgnoreCase((CharSequence)lines[i], (CharSequence)this.pattern) || CommentContainsPatternChecker.isLetterAround(lines[i], this.pattern)) continue;
                this.newCheck.addIssue(syntaxTrivia.range().start().line() + i, this.message);
            }
        }
    }
}

