/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5329")
public class CollectionConstructorReferenceCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.util.ArrayList", "java.util.HashMap", "java.util.HashSet", "java.util.Hashtable", "java.util.IdentityHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.PriorityQueue", "java.util.Vector", "java.util.WeakHashMap"}).constructor().addParametersMatcher(new String[]{"int"}).build();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_REFERENCE);
    }

    @Override
    protected void onMethodReferenceFound(MethodReferenceTree methodReference) {
        if ("java.util.function.Function".equals(methodReference.symbolType().fullyQualifiedName())) {
            String methodOwnerTypeName = ((ExpressionTree)methodReference.expression()).symbolType().name();
            this.reportIssue((Tree)methodReference, String.format("Replace this method reference by a lambda to explicitly show the usage of %1$s(int %2$s) or %1$s().", methodOwnerTypeName, "IdentityHashMap".equals(methodOwnerTypeName) ? "expectedMaxSize" : "initialCapacity"));
        }
    }
}

