/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S2184")
public class CastArithmeticOperandCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Map<Tree.Kind, String> OPERATION_BY_KIND = MapBuilder.newMap().put((Object)Tree.Kind.PLUS, (Object)"addition").put((Object)Tree.Kind.MINUS, (Object)"subtraction").put((Object)Tree.Kind.MULTIPLY, (Object)"multiplication").put((Object)Tree.Kind.DIVIDE, (Object)"division").build();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitAssignmentExpression(AssignmentExpressionTree aet) {
        if (aet.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            Type varType = aet.symbolType();
            ExpressionTree expr = aet.expression();
            this.checkExpression(varType, expr);
        }
        super.visitAssignmentExpression(aet);
    }

    public void visitVariable(VariableTree tree) {
        Type varType = tree.type().symbolType();
        this.checkExpression(varType, tree.initializer());
        super.visitVariable(tree);
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        this.checkMethodInvocationArgument(tree.arguments(), tree.symbol());
        super.visitMethodInvocation(tree);
    }

    public void visitMethod(MethodTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.checkMethodTree(tree);
        }
        super.visitMethod(tree);
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        boolean continueVisit = true;
        if (tree.is(new Tree.Kind[]{Tree.Kind.DIVIDE}) && CastArithmeticOperandCheck.isIntOrLong(tree.symbolType())) {
            continueVisit = this.checkIntegerDivisionInsideFloatingPointExpression(tree);
        }
        if (continueVisit) {
            super.visitBinaryExpression(tree);
        }
    }

    public void visitNewClass(NewClassTree tree) {
        this.checkMethodInvocationArgument(tree.arguments(), tree.constructorSymbol());
        super.visitNewClass(tree);
    }

    private void checkMethodTree(MethodTree methodTree) {
        Type returnType;
        TypeTree returnTypeTree = methodTree.returnType();
        Type type = returnType = returnTypeTree != null ? returnTypeTree.symbolType() : null;
        if (returnType != null && CastArithmeticOperandCheck.isVarTypeErrorProne(returnType)) {
            methodTree.accept((TreeVisitor)new ReturnStatementVisitor(returnType));
        }
    }

    private void checkMethodInvocationArgument(Arguments arguments, Symbol symbol) {
        if (symbol.isMethodSymbol()) {
            List parametersTypes = ((Symbol.MethodSymbol)symbol).parameterTypes();
            if (arguments.size() == parametersTypes.size()) {
                int i = 0;
                for (Type argType : parametersTypes) {
                    this.checkExpression(argType, (ExpressionTree)arguments.get(i));
                    ++i;
                }
            }
        }
    }

    private void checkExpression(Type varType, @Nullable ExpressionTree expr) {
        if (CastArithmeticOperandCheck.isVarTypeErrorProne(varType) && expr != null && CastArithmeticOperandCheck.expressionIsOperationToIntOrLong(expr)) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)expr;
            if (binaryExpressionTree.is(new Tree.Kind[]{Tree.Kind.DIVIDE}) && varType.isPrimitive(Type.Primitives.LONG)) {
                return;
            }
            if (varType.isPrimitive(Type.Primitives.LONG) && expr.symbolType().isPrimitive(Type.Primitives.LONG)) {
                return;
            }
            this.context.reportIssue((JavaCheck)this, (Tree)binaryExpressionTree.operatorToken(), "Cast one of the operands of this " + OPERATION_BY_KIND.get(expr.kind()) + " operation to a \"" + varType.name() + "\".");
        }
    }

    private static boolean expressionIsOperationToIntOrLong(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.PLUS, Tree.Kind.MINUS}) && CastArithmeticOperandCheck.isIntOrLong(expr.symbolType());
    }

    private static boolean isIntOrLong(Type exprType) {
        return exprType.isPrimitive(Type.Primitives.INT) || exprType.isPrimitive(Type.Primitives.LONG);
    }

    private static boolean isVarTypeErrorProne(Type varType) {
        return varType.isPrimitive(Type.Primitives.LONG) || varType.isPrimitive(Type.Primitives.FLOAT) || varType.isPrimitive(Type.Primitives.DOUBLE);
    }

    private boolean checkIntegerDivisionInsideFloatingPointExpression(BinaryExpressionTree integerDivision) {
        Tree parent = integerDivision.parent();
        while (parent instanceof ExpressionTree) {
            ExpressionTree expressionTree = (ExpressionTree)parent;
            if (CastArithmeticOperandCheck.isFloatingPoint(expressionTree.symbolType())) {
                this.context.reportIssue((JavaCheck)this, (Tree)integerDivision, "Cast one of the operands of this integer division to a \"double\".");
                return false;
            }
            parent = expressionTree.parent();
        }
        return true;
    }

    private static boolean isFloatingPoint(Type exprType) {
        return exprType.isPrimitive(Type.Primitives.DOUBLE) || exprType.isPrimitive(Type.Primitives.FLOAT);
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private Type returnType;

        public ReturnStatementVisitor(Type returnType) {
            this.returnType = returnType;
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            CastArithmeticOperandCheck.this.checkExpression(this.returnType, tree.expression());
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

