/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.web;

import java.util.Collections;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.java.checks.xml.web.AbstractWebXmlXPathBasedCheck;
import org.sonarsource.analyzer.commons.xml.XmlFile;

@Rule(key="S3369")
public class SecurityConstraintsInWebXmlCheck
extends AbstractWebXmlXPathBasedCheck {
    private XPathExpression securityConstraintExpression = this.getXPathExpression("web-app/security-constraint");

    private boolean hasNoSecurityConstraint(XmlFile file) {
        return this.evaluateAsList(this.securityConstraintExpression, file.getNamespaceUnawareDocument()).isEmpty();
    }

    @Override
    public void scanWebXml(XmlFile file) {
        if (this.hasNoSecurityConstraint(file)) {
            this.reportIssueOnFile("Add \"security-constraint\" elements to this descriptor.", Collections.emptyList());
        }
    }
}

