/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven;

import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="S3419")
public class GroupIdNamingConventionCheck
extends SimpleXPathBasedCheck {
    public static final String KEY = "S3419";
    private static final String DEFAULT_REGEX = "(com|org)(\\.[a-z][a-z-0-9]*)+";
    @RuleProperty(key="regex", description="The regular expression the \"groupId\" should match", defaultValue="(com|org)(\\.[a-z][a-z-0-9]*)+")
    public String regex = "(com|org)(\\.[a-z][a-z-0-9]*)+";
    private XPathExpression groupIdExpression = this.getXPathExpression("project/groupId");
    private Pattern pattern = null;

    public void scanFile(XmlFile file) {
        if (!"pom.xml".equalsIgnoreCase(file.getInputFile().filename())) {
            return;
        }
        NodeList groupIds = this.evaluate(this.groupIdExpression, file.getNamespaceUnawareDocument());
        if (groupIds == null || groupIds.getLength() != 1) {
            return;
        }
        Node groupId = groupIds.item(0);
        if (!this.getPattern().matcher(groupId.getTextContent()).matches()) {
            this.reportIssue(groupId, "Update this \"groupId\" to match the provided regular expression: '" + this.regex + "'");
        }
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            try {
                this.pattern = Pattern.compile(this.regex, 32);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[S3419] Unable to compile the regular expression: " + this.regex, e);
            }
        }
        return this.pattern;
    }
}

