/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2255")
public class CookieShouldNotContainSensitiveDataCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure that this cookie is used safely.";
    private static final List<String> COOKIE_ARGUMENT_TYPES = Arrays.asList("javax.servlet.http.Cookie", "javax.ws.rs.core.Cookie", "org.apache.shiro.web.servlet.Cookie");
    private static final String SET_VALUE_METHOD = "setValue";
    private static final String WITH_VALUE_METHOD = "withValue";
    private static final String BUILDER_METHOD = "builder";
    private static final String JAVA_LANG_STRING = "java.lang.String";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"javax.servlet.http.Cookie", "java.net.HttpCookie", "org.apache.shiro.web.servlet.SimpleCookie"}).names(new String[]{SET_VALUE_METHOD}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.servlet.http.Cookie", "java.net.HttpCookie", "org.apache.shiro.web.servlet.SimpleCookie"}).constructor().withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.ws.rs.core.Cookie"}).constructor().withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"play.mvc.Http$Cookie"}).names(new String[]{BUILDER_METHOD}).addParametersMatcher(new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING}).build(), MethodMatchers.create().ofSubTypes(new String[]{"play.mvc.Http$CookieBuilder"}).names(new String[]{WITH_VALUE_METHOD}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).build()});
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_REFERENCE);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree methodTree) {
        if (methodTree.symbol().name().equals(BUILDER_METHOD)) {
            if (CookieShouldNotContainSensitiveDataCheck.secondArgumentIsValue(methodTree.arguments())) {
                this.reportIssue((Tree)methodTree.arguments().get(1), MESSAGE);
            }
        } else if (CookieShouldNotContainSensitiveDataCheck.isNotNullOrWhitespace((ExpressionTree)methodTree.arguments().get(0))) {
            this.reportIssue((Tree)methodTree.arguments().get(0), MESSAGE);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (CookieShouldNotContainSensitiveDataCheck.firstArgumentIsCookie(newClassTree.arguments())) {
            this.reportIssue((Tree)newClassTree.arguments().get(0), MESSAGE);
        } else if (CookieShouldNotContainSensitiveDataCheck.secondArgumentIsValue(newClassTree.arguments())) {
            this.reportIssue((Tree)newClassTree.arguments().get(1), MESSAGE);
        }
    }

    private static boolean firstArgumentIsCookie(Arguments arguments) {
        if (arguments.isEmpty()) {
            return false;
        }
        ExpressionTree firstArgument = (ExpressionTree)arguments.get(0);
        return COOKIE_ARGUMENT_TYPES.stream().anyMatch(type -> firstArgument.symbolType().isSubtypeOf(type));
    }

    private static boolean secondArgumentIsValue(Arguments arguments) {
        if (arguments.size() < 2) {
            return false;
        }
        ExpressionTree secondArgument = (ExpressionTree)arguments.get(1);
        return secondArgument.symbolType().isSubtypeOf(JAVA_LANG_STRING) && CookieShouldNotContainSensitiveDataCheck.isNotNullOrWhitespace(secondArgument);
    }

    private static boolean isNotNullOrWhitespace(ExpressionTree tree) {
        return !tree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) && !tree.asConstant(String.class).filter(StringUtils::isBlank).isPresent();
    }

    private static class ClassName {
        private static final String SERVLET_COOKIE = "javax.servlet.http.Cookie";
        private static final String NET_HTTP_COOKIE = "java.net.HttpCookie";
        private static final String JAX_RS_COOKIE = "javax.ws.rs.core.Cookie";
        private static final String SHIRO_COOKIE = "org.apache.shiro.web.servlet.SimpleCookie";
        private static final String PLAY_COOKIE = "play.mvc.Http$Cookie";
        private static final String PLAY_COOKIE_BUILDER = "play.mvc.Http$CookieBuilder";

        private ClassName() {
        }
    }
}

