/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4823")
public class CommandLineArgumentsCheck
extends IssuableSubscriptionVisitor {
    private static final String ARGS4J_OPTION_ANNOTATION = "org.kohsuke.args4j.Option";
    private static final String ARGS4J_ARGUMENT_ANNOTATION = "org.kohsuke.args4j.Argument";
    private static final String MESSAGE = "Make sure that command line arguments are used safely here.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            MethodTree methodTree = (MethodTree)member;
            if (MethodTreeUtils.isMainMethod(methodTree)) {
                this.checkMainMethodArgsUsage(methodTree);
                continue;
            }
            if (!"run".equals(methodTree.simpleName().name())) continue;
            this.checkArgs4J(methodTree.simpleName(), classTree);
        }
    }

    private void checkArgs4J(IdentifierTree methodIdentifier, ClassTree classTree) {
        List args4JAnnotatedMembers = classTree.members().stream().filter(CommandLineArgumentsCheck::hasArgs4JAnnotation).collect(Collectors.toList());
        if (!args4JAnnotatedMembers.isEmpty()) {
            List secondaries = args4JAnnotatedMembers.stream().map(member -> new JavaFileScannerContext.Location("", member)).collect(Collectors.toList());
            this.reportIssue((Tree)methodIdentifier, MESSAGE, secondaries, null);
        }
    }

    private static boolean hasArgs4JAnnotation(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            return CommandLineArgumentsCheck.hasArgs4JAnnotation((Symbol)((MethodTree)tree).symbol());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return CommandLineArgumentsCheck.hasArgs4JAnnotation(((VariableTree)tree).symbol());
        }
        return false;
    }

    private static boolean hasArgs4JAnnotation(Symbol symbol) {
        return symbol.metadata().isAnnotatedWith(ARGS4J_OPTION_ANNOTATION) || symbol.metadata().isAnnotatedWith(ARGS4J_ARGUMENT_ANNOTATION);
    }

    private void checkMainMethodArgsUsage(MethodTree mainMethod) {
        VariableTree commandLineParameters = (VariableTree)mainMethod.parameters().get(0);
        List argsUsages = commandLineParameters.symbol().usages();
        if (!argsUsages.isEmpty()) {
            List secondaries = argsUsages.stream().map(usage -> new JavaFileScannerContext.Location("", (Tree)usage)).collect(Collectors.toList());
            this.reportIssue((Tree)commandLineParameters, MESSAGE, secondaries, null);
        }
    }
}

