/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00115", repositoryKey="squid")
@Rule(key="S115")
public class BadConstantNameCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_FORMAT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    @RuleProperty(key="format", description="Regular expression used to check the constant names against.", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    public String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
    }

    public void setContext(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)member;
                Type symbolType = variableTree.type().symbolType();
                if (!BadConstantNameCheck.isConstantType(symbolType) || !classTree.is(new Tree.Kind[]{Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE}) && !BadConstantNameCheck.isStaticFinal(variableTree)) continue;
                this.checkName(variableTree);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT})) continue;
            this.checkName((VariableTree)member);
        }
    }

    private static boolean isConstantType(Type symbolType) {
        return symbolType.isPrimitive() || symbolType.is("java.lang.String") || JUtils.isPrimitiveWrapper((Type)symbolType);
    }

    private void checkName(VariableTree variableTree) {
        if (!"serialVersionUID".equals(variableTree.simpleName().name()) && !this.pattern.matcher(variableTree.simpleName().name()).matches()) {
            this.reportIssue((Tree)variableTree.simpleName(), "Rename this constant name to match the regular expression '" + this.format + "'.");
        }
    }

    private static boolean isStaticFinal(VariableTree variableTree) {
        boolean isStatic = false;
        boolean isFinal = false;
        for (ModifierKeywordTree modifierKeywordTree : variableTree.modifiers().modifiers()) {
            Modifier modifier = modifierKeywordTree.modifier();
            if (modifier == Modifier.STATIC) {
                isStatic = true;
            }
            if (modifier != Modifier.FINAL) continue;
            isFinal = true;
        }
        return isStatic && isFinal;
    }
}

