/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.List;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;

public final class SpringUtils {
    public static final String SPRING_SCOPE_ANNOTATION = "org.springframework.context.annotation.Scope";

    private SpringUtils() {
    }

    public static boolean isScopeSingleton(SymbolMetadata clazzMeta) {
        List values = clazzMeta.valuesForAnnotation(SPRING_SCOPE_ANNOTATION);
        if (values == null) {
            return true;
        }
        for (SymbolMetadata.AnnotationValue annotationValue : values) {
            if (!"value".equals(annotationValue.name()) && !"scopeName".equals(annotationValue.name())) continue;
            Object value = annotationValue.value();
            String stringValue = null;
            if (value instanceof String) {
                stringValue = (String)value;
            }
            if (stringValue == null || "singleton".equals(stringValue)) continue;
            return false;
        }
        return true;
    }
}

