/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.cfg.CFG;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S128")
public class SwitchCaseWithoutBreakCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        HashSet<CaseGroupTree> caseGroupTrees = new HashSet<CaseGroupTree>(switchStatementTree.cases());
        CFG cfg = CFG.buildCFG(Collections.singletonList(tree), (boolean)true);
        Set switchSuccessors = cfg.entryBlock().successors();
        Map<CFG.Block, CaseGroupTree> cfgBlockToCaseGroupMap = SwitchCaseWithoutBreakCheck.createMapping(switchSuccessors, caseGroupTrees);
        switchSuccessors.stream().filter(cfgBlockToCaseGroupMap.keySet()::contains).flatMap(cfgBlock -> SwitchCaseWithoutBreakCheck.getForbiddenCaseGroupPredecessors(cfgBlock, cfgBlockToCaseGroupMap)).map(CaseGroupTree::labels).map(caseGroupLabels -> (CaseLabelTree)caseGroupLabels.get(caseGroupLabels.size() - 1)).forEach(label -> this.reportIssue((Tree)label, "End this switch case with an unconditional break, return or throw statement."));
    }

    private static Map<CFG.Block, CaseGroupTree> createMapping(Set<CFG.Block> switchSuccessors, Set<CaseGroupTree> caseGroupTrees) {
        return switchSuccessors.stream().filter(cfgBlock -> cfgBlock.caseGroup() != null && caseGroupTrees.contains(cfgBlock.caseGroup())).collect(Collectors.toMap(Function.identity(), CFG.Block::caseGroup));
    }

    private static Stream<CaseGroupTree> getForbiddenCaseGroupPredecessors(CFG.Block cfgBlock, Map<CFG.Block, CaseGroupTree> cfgBlockToCaseGroupMap) {
        CaseGroupTree caseGroup = cfgBlockToCaseGroupMap.get(cfgBlock);
        return cfgBlock.predecessors().stream().map(predecessor -> SwitchCaseWithoutBreakCheck.getForbiddenCaseGroupPredecessor(predecessor, cfgBlockToCaseGroupMap, new HashSet<CFG.Block>())).filter(Objects::nonNull).filter(predecessor -> !SwitchCaseWithoutBreakCheck.intentionalFallThrough((Tree)predecessor, (Tree)caseGroup)).distinct();
    }

    @Nullable
    private static CaseGroupTree getForbiddenCaseGroupPredecessor(CFG.Block predecessor, Map<CFG.Block, CaseGroupTree> cfgBlockToCaseGroupMap, Set<CFG.Block> seen) {
        if (cfgBlockToCaseGroupMap.get(predecessor) != null) {
            return cfgBlockToCaseGroupMap.get(predecessor);
        }
        if (seen.contains(predecessor)) {
            return null;
        }
        seen.add(predecessor);
        return predecessor.predecessors().stream().map(previousPredecessors -> SwitchCaseWithoutBreakCheck.getForbiddenCaseGroupPredecessor(previousPredecessors, cfgBlockToCaseGroupMap, seen)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static boolean intentionalFallThrough(Tree caseGroup, Tree nextCaseGroup) {
        FallThroughCommentVisitor visitor = new FallThroughCommentVisitor();
        CaseGroupTree caseGroupTree = (CaseGroupTree)caseGroup;
        List treesToScan = Stream.of(caseGroupTree.body(), Collections.singletonList(nextCaseGroup.firstToken())).flatMap(Collection::stream).collect(Collectors.toList());
        visitor.scan(treesToScan);
        return visitor.hasComment;
    }

    private static class FallThroughCommentVisitor
    extends SubscriptionVisitor {
        private static final Pattern FALL_THROUGH_PATTERN = Pattern.compile("falls?[\\-\\s]?thro?u[gh]?", 2);
        boolean hasComment = false;

        private FallThroughCommentVisitor() {
        }

        public List<Tree.Kind> nodesToVisit() {
            return Collections.singletonList(Tree.Kind.TRIVIA);
        }

        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            if (!this.hasComment && FALL_THROUGH_PATTERN.matcher(syntaxTrivia.comment()).find()) {
                this.hasComment = true;
            }
        }

        private void scan(List<Tree> trees) {
            for (Tree tree : trees) {
                if (this.hasComment) {
                    return;
                }
                this.scanTree(tree);
            }
        }
    }
}

