/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractForLoopRule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S888")
public class ForLoopTerminationConditionCheck
extends AbstractForLoopRule {
    @Override
    public void visitForStatement(ForStatementTree forStatement) {
        ExpressionTree condition = forStatement.condition();
        if (condition == null || !condition.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
            return;
        }
        BinaryExpressionTree inequalityCondition = (BinaryExpressionTree)condition;
        IntInequality loopVarAndTerminalValue = IntInequality.of(inequalityCondition);
        if (loopVarAndTerminalValue != null) {
            IdentifierTree loopIdentifier = loopVarAndTerminalValue.identifier;
            int terminationValue = loopVarAndTerminalValue.literalValue;
            Integer initialValue = ForLoopTerminationConditionCheck.initialValue(loopIdentifier, forStatement);
            if (initialValue != null && initialValue != terminationValue) {
                this.checkIncrement(forStatement, loopIdentifier, initialValue < terminationValue);
            }
        }
    }

    private void checkIncrement(ForStatementTree forStatement, IdentifierTree loopIdentifier, boolean positiveIncrement) {
        if (forStatement.update().size() <= 1) {
            AbstractForLoopRule.ForLoopIncrement loopIncrement = AbstractForLoopRule.ForLoopIncrement.findInUpdates(forStatement);
            if (loopIncrement == null || !loopIncrement.hasSameIdentifier((ExpressionTree)loopIdentifier)) {
                this.addIssue(forStatement);
            } else if (loopIncrement.hasValue()) {
                int requiredIncrement;
                int n = requiredIncrement = positiveIncrement ? 1 : -1;
                if (loopIncrement.value() != requiredIncrement || ForLoopTerminationConditionCheck.forBodyUpdatesLoopIdentifier(forStatement, loopIdentifier)) {
                    this.addIssue(forStatement);
                }
            }
        }
    }

    private void addIssue(ForStatementTree tree) {
        this.reportIssue((Tree)tree.condition(), "Replace '!=' operator with one of '<=', '>=', '<', or '>' comparison operators.");
    }

    private static boolean forBodyUpdatesLoopIdentifier(ForStatementTree forStatement, IdentifierTree loopIdentifier) {
        LoopVariableAssignmentVisitor visitor = new LoopVariableAssignmentVisitor(loopIdentifier);
        forStatement.statement().accept((TreeVisitor)visitor);
        return visitor.foundAssignment;
    }

    private static Integer initialValue(IdentifierTree loopIdentifier, ForStatementTree forStatement) {
        Integer value = null;
        for (AbstractForLoopRule.ForLoopInitializer initializer : AbstractForLoopRule.ForLoopInitializer.list(forStatement)) {
            if (!initializer.hasSameIdentifier((ExpressionTree)loopIdentifier) || initializer.value() == null) continue;
            value = initializer.value();
        }
        return value;
    }

    private static class IntInequality {
        private final IdentifierTree identifier;
        private final int literalValue;

        private IntInequality(IdentifierTree identifier, int value) {
            this.identifier = identifier;
            this.literalValue = value;
        }

        public static IntInequality of(BinaryExpressionTree binaryExp) {
            Integer value = null;
            IdentifierTree identifier = null;
            for (ExpressionTree expressionTree : Arrays.asList(binaryExp.leftOperand(), binaryExp.rightOperand())) {
                if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    identifier = (IdentifierTree)expressionTree;
                    continue;
                }
                value = LiteralUtils.intLiteralValue((ExpressionTree)expressionTree);
            }
            if (identifier != null && value != null) {
                return new IntInequality(identifier, value);
            }
            return null;
        }
    }

    private static class LoopVariableAssignmentVisitor
    extends BaseTreeVisitor {
        private final IdentifierTree loopIdentifier;
        private boolean foundAssignment = false;

        public LoopVariableAssignmentVisitor(IdentifierTree loopIdentifier) {
            this.loopIdentifier = loopIdentifier;
        }

        public void visitUnaryExpression(UnaryExpressionTree unaryExp) {
            if (AbstractForLoopRule.isSameIdentifier(this.loopIdentifier, unaryExp.expression()) && unaryExp.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT})) {
                this.foundAssignment = true;
            }
            super.visitUnaryExpression(unaryExp);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree assignmentExpression) {
            if (AbstractForLoopRule.isSameIdentifier(this.loopIdentifier, assignmentExpression.variable())) {
                this.foundAssignment = true;
            }
            super.visitAssignmentExpression(assignmentExpression);
        }
    }
}

