/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2973")
public class EscapedUnicodeCharactersCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> UNICODE_WHITESPACES = SetUtils.immutableSetOf((Object[])new String[]{"1680", "2000", "2001", "2002", "2003", "2004", "2005", "2006", "2007", "2008", "2009", "200A", "2028", "2029", "202F", "205F", "3000", "180E", "200B", "200C", "200D", "2060", "FEFF"});
    private static final Pattern UNICODE_ESCAPED_CHAR = Pattern.compile("\\\\u+[a-fA-F0-9]{4}");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK);
    }

    public void visitNode(Tree node) {
        Matcher matcher;
        List<String> matches;
        if (LiteralUtils.isEmptyString((Tree)node)) {
            return;
        }
        String value = LiteralUtils.trimQuotes((String)((LiteralTree)node).value());
        if (node.is(new Tree.Kind[]{Tree.Kind.TEXT_BLOCK})) {
            value = value.replaceAll("(\r?\n|\r)\\s*", "");
        }
        if (!(matches = EscapedUnicodeCharactersCheck.getAllMatches(matcher = UNICODE_ESCAPED_CHAR.matcher(value.replace("\\\\", "")))).isEmpty()) {
            boolean notOnlyUnicodeEscaped;
            boolean bl = notOnlyUnicodeEscaped = !matcher.replaceAll("").isEmpty();
            if (notOnlyUnicodeEscaped && matches.stream().anyMatch(EscapedUnicodeCharactersCheck::isPrintableEscapedUnicode)) {
                this.reportIssue(node, "Remove this Unicode escape sequence and use the character instead.");
            }
        }
    }

    private static List<String> getAllMatches(Matcher matcher) {
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    private static boolean isPrintableEscapedUnicode(String input) {
        String hexValue = input.substring(input.length() - 4).toUpperCase(Locale.ROOT);
        if (UNICODE_WHITESPACES.contains(hexValue)) {
            return false;
        }
        int unicodePointDecimal = Integer.parseInt(hexValue, 16);
        return 31 < unicodePointDecimal && unicodePointDecimal < 127 || 160 < unicodePointDecimal;
    }
}

