/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5669")
public class ConfusingVarargCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers ALLOWED_VARARG_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.Class"}).names(new String[]{"getMethod", "getDeclaredMethod"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.Class[]"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Class"}).names(new String[]{"getConstructor", "getDeclaredConstructor"}).addParametersMatcher(new String[]{"java.lang.Class[]"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Method"}).names(new String[]{"invoke"}).addParametersMatcher(new String[]{"java.lang.Object", "java.lang.Object[]"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Constructor"}).names(new String[]{"newInstance"}).addParametersMatcher(new String[]{"java.lang.Object[]"}).build()});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        Arguments arguments;
        Symbol symbol;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            symbol = mit.symbol();
            arguments = mit.arguments();
        } else {
            NewClassTree nct = (NewClassTree)tree;
            symbol = nct.constructorSymbol();
            arguments = nct.arguments();
        }
        if (symbol.isMethodSymbol() && !ALLOWED_VARARG_METHODS.matches(symbol)) {
            this.checkConfusingVararg((Symbol.MethodSymbol)symbol, arguments);
        }
    }

    private void checkConfusingVararg(Symbol.MethodSymbol method, Arguments arguments) {
        if (!JUtils.isVarArgsMethod((Symbol.MethodSymbol)method)) {
            return;
        }
        List parameterTypes = method.parameterTypes();
        if (arguments.size() != parameterTypes.size()) {
            return;
        }
        Type varargParameter = (Type)parameterTypes.get(parameterTypes.size() - 1);
        ExpressionTree varargArgument = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)arguments.get(arguments.size() - 1)));
        Type varargArgumentType = varargArgument.symbolType();
        if (varargArgument.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || ConfusingVarargCheck.isIncompatibleArray(varargArgumentType, varargParameter)) {
            this.reportIssue((Tree)varargArgument, ConfusingVarargCheck.message(varargParameter, varargArgumentType));
        }
    }

    private static boolean isIncompatibleArray(Type varargArgument, Type varargParameter) {
        return ConfusingVarargCheck.isPrimitiveArray(varargArgument) && !ConfusingVarargCheck.isPrimitiveArray(varargParameter) && !varargArgument.equals(((Type.ArrayType)varargParameter).elementType());
    }

    private static boolean isPrimitiveArray(Type type) {
        return type.isArray() && ((Type.ArrayType)type).elementType().isPrimitive();
    }

    private static String message(Type varargParameter, Type varargArgument) {
        String message = "Cast this argument to '%s' to pass a single element to the vararg method.";
        Type parameterType = ((Type.ArrayType)varargParameter).elementType();
        if (parameterType.isPrimitive()) {
            message = "Remove this argument or pass an empty '%s' array to the vararg method.";
        } else if (ConfusingVarargCheck.isPrimitiveArray(varargArgument)) {
            Type argumentType = ((Type.ArrayType)varargArgument).elementType();
            return String.format("Use an array of '%s' instead of an array of '%s'.", JUtils.primitiveWrapperType((Type)argumentType).name(), argumentType.name());
        }
        return String.format(message, parameterType.name());
    }
}

