/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.lex;

import java.util.List;
import org.sonar.channel.CodeReader;
import org.sonar.channel.EndMatcher;
import org.sonar.plugins.html.lex.AbstractTokenizer;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.NodeType;
import org.sonar.plugins.html.node.TagNode;
import org.sonar.plugins.html.node.TextNode;

class TextTokenizer
extends AbstractTokenizer<List<Node>> {
    private final EndMatcher endTokenMatcher = new EndTokenMatcher();

    public TextTokenizer() {
        super("", "");
    }

    @Override
    public boolean consume(CodeReader codeReader, List<Node> nodeList) {
        Node node = this.createNode();
        this.setStartPosition(codeReader, node);
        StringBuilder stringBuilder = new StringBuilder();
        if (TextTokenizer.inScript(nodeList)) {
            codeReader.popTo(new EndScriptMatcher(codeReader), (Appendable)stringBuilder);
        } else {
            codeReader.popTo(this.endTokenMatcher, (Appendable)stringBuilder);
        }
        node.setCode(stringBuilder.toString());
        this.setEndPosition(codeReader, node);
        nodeList.add(node);
        return true;
    }

    private static boolean inScript(List<Node> nodeList) {
        Node node;
        if (!nodeList.isEmpty() && (node = nodeList.get(nodeList.size() - 1)).getNodeType() == NodeType.TAG) {
            TagNode tag = (TagNode)node;
            return !tag.isEndElement() && "script".equalsIgnoreCase(tag.getNodeName());
        }
        return false;
    }

    @Override
    Node createNode() {
        return new TextNode();
    }

    private static class EndScriptMatcher
    implements EndMatcher {
        private final CodeReader codeReader;
        private static final String END_SCRIPT = "</script>";

        public EndScriptMatcher(CodeReader codeReader) {
            this.codeReader = codeReader;
        }

        @Override
        public boolean match(int endFlag) {
            if (endFlag == 65535) {
                return true;
            }
            return (char)endFlag == '<' && END_SCRIPT.equalsIgnoreCase(new String(this.codeReader.peek(END_SCRIPT.length())));
        }
    }

    private static final class EndTokenMatcher
    implements EndMatcher {
        private EndTokenMatcher() {
        }

        @Override
        public boolean match(int endFlag) {
            return endFlag == 60;
        }
    }
}

