/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S4084")
public class VideoTrackCheck
extends AbstractPageCheck {
    private static final Set<String> ACCESSIBILITY_TRACK_KINDS = new HashSet<String>(Arrays.asList("captions", "descriptions", "subtitles"));

    @Override
    public void startElement(TagNode node) {
        if (VideoTrackCheck.isVideoTag(node) && VideoTrackCheck.hasVideoSrc(node) && !VideoTrackCheck.hasAccessibilityTrackDescendant(node)) {
            this.createViolation(node, "Add subtitles and description files for this video.");
        }
    }

    private static boolean hasVideoSrc(TagNode node) {
        return node.hasProperty("SRC") || VideoTrackCheck.hasVideoSrcDescendant(node);
    }

    private static boolean hasVideoSrcDescendant(TagNode node) {
        return node.getChildren().stream().anyMatch(VideoTrackCheck::isSourceTag) || node.getChildren().stream().anyMatch(VideoTrackCheck::hasVideoSrcDescendant);
    }

    private static boolean hasAccessibilityTrackDescendant(TagNode node) {
        return node.getChildren().stream().anyMatch(VideoTrackCheck::isAccessibilityTrackTag) || node.getChildren().stream().anyMatch(VideoTrackCheck::hasAccessibilityTrackDescendant);
    }

    private static boolean isVideoTag(TagNode node) {
        return node.equalsElementName("VIDEO");
    }

    private static boolean isSourceTag(TagNode node) {
        return node.equalsElementName("SOURCE");
    }

    private static boolean isAccessibilityTrackTag(TagNode node) {
        return node.equalsElementName("TRACK") && ACCESSIBILITY_TRACK_KINDS.contains(node.getPropertyValue("KIND"));
    }
}

