/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S5258")
public class LayoutTableWithSemanticMarkupCheck
extends AbstractPageCheck {
    private Deque<Boolean> isWithinLayoutTable = new LinkedList<Boolean>();

    @Override
    public void startDocument(List<Node> nodes) {
        this.isWithinLayoutTable.clear();
    }

    @Override
    public void endDocument() {
        this.isWithinLayoutTable.clear();
    }

    @Override
    public void startElement(TagNode node) {
        if (LayoutTableWithSemanticMarkupCheck.isTable(node)) {
            this.isWithinLayoutTable.addFirst(LayoutTableWithSemanticMarkupCheck.isLayout(node));
            if (Boolean.TRUE.equals(this.isWithinLayoutTable.peekFirst())) {
                this.raiseViolationOnAttribute(node, "SUMMARY");
            }
        }
        if (Boolean.TRUE.equals(this.isWithinLayoutTable.peekFirst())) {
            if (LayoutTableWithSemanticMarkupCheck.isCaption(node) || LayoutTableWithSemanticMarkupCheck.isTableHeader(node)) {
                this.createViolation(node, String.format("Remove this \"%s\" element", node.getNodeName()));
            } else if (LayoutTableWithSemanticMarkupCheck.isTableColumn(node)) {
                this.raiseViolationOnAttribute(node, "HEADERS");
                this.raiseViolationOnAttribute(node, "SCOPE");
            }
        }
    }

    @Override
    public void endElement(TagNode node) {
        if (LayoutTableWithSemanticMarkupCheck.isTable(node) && !this.isWithinLayoutTable.isEmpty()) {
            this.isWithinLayoutTable.removeFirst();
        }
    }

    private void raiseViolationOnAttribute(TagNode node, String attributeName) {
        LayoutTableWithSemanticMarkupCheck.findAttribute(node, attributeName).ifPresent(attribute -> this.createViolation(attribute.getLine(), String.format("Remove this \"%s\" attribute", attribute.getName())));
    }

    private static boolean isTable(TagNode node) {
        return "TABLE".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isCaption(TagNode node) {
        return "CAPTION".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isTableHeader(TagNode node) {
        return "TH".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isTableColumn(TagNode node) {
        return "TD".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isLayout(TagNode node) {
        String role = node.getAttribute("role");
        return role != null && ("PRESENTATION".equalsIgnoreCase(role) || "NONE".equalsIgnoreCase(role));
    }

    private static Optional<Attribute> findAttribute(TagNode node, String attributeName) {
        return node.getAttributes().stream().filter(a -> attributeName.equalsIgnoreCase(a.getName())).findAny();
    }
}

